/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.Arrays;

public enum PortLtpCrcMode {
    STL_PORT_LTP_CRC_MODE_NONE(0),
    STL_PORT_LTP_CRC_MODE_14(1),
    STL_PORT_LTP_CRC_MODE_16(2),
    STL_PORT_LTP_CRC_MODE_48(4),
    STL_PORT_LTP_CRC_MODE_12_16_PER_LANE(8);

    private final byte mode;

    private PortLtpCrcMode(byte mode) {
        this.mode = mode;
    }

    public byte getMode() {
        return this.mode;
    }

    public static PortLtpCrcMode getPortLtpCrcMode(byte mode) {
        for (PortLtpCrcMode plcm : PortLtpCrcMode.values()) {
            if (plcm.getMode() != mode) continue;
            return plcm;
        }
        throw new IllegalArgumentException("Unsupported PortLtpCrcMode " + StringUtils.byteHexString(mode));
    }

    public static PortLtpCrcMode[] getPortLtpCrcModes(byte mode) {
        if (PortLtpCrcMode.isNoneSupported(mode)) {
            return new PortLtpCrcMode[]{STL_PORT_LTP_CRC_MODE_NONE};
        }
        PortLtpCrcMode[] portLtpCrcModes = PortLtpCrcMode.values();
        PortLtpCrcMode[] modes = new PortLtpCrcMode[portLtpCrcModes.length];
        int numModes = 0;
        for (PortLtpCrcMode plcm : portLtpCrcModes) {
            if (plcm == STL_PORT_LTP_CRC_MODE_NONE || (plcm.mode & mode) != plcm.mode) continue;
            modes[numModes] = plcm;
            ++numModes;
        }
        return Arrays.copyOf(modes, numModes);
    }

    public static boolean isNoneSupported(byte mode) {
        return mode == PortLtpCrcMode.STL_PORT_LTP_CRC_MODE_NONE.mode;
    }
}

