/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.failure;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.failure.FailureType;
import com.intel.stl.api.failure.IFailureManagement;
import com.intel.stl.api.failure.ITaskFailure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureRecoverManagement
implements IFailureManagement {
    private static final Logger log = LoggerFactory.getLogger(FailureRecoverManagement.class);
    private static boolean DEBUG = false;
    private static final long SHUTDOWN_TIME = 1000L;
    public static final int DEFAULT_TOLERANCE = 3;
    public static final long DEFAULT_MEM_LENGTH = 180000L;
    public static final long DEFAULT_RETRY_INTERVAL = 10000L;
    private final int tolerance;
    private final long memoryLength;
    private final long retryInterval;
    private final Map<Object, FailureItem> items;
    private final ScheduledExecutorService executor;

    public FailureRecoverManagement() {
        this(3, 180000L, 10000L);
    }

    public FailureRecoverManagement(int tolerance, long memoryLength, long retryInterval) {
        this.tolerance = tolerance;
        this.memoryLength = memoryLength;
        this.retryInterval = retryInterval;
        this.items = new HashMap<Object, FailureItem>();
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public int getTolerance() {
        return this.tolerance;
    }

    @Override
    public synchronized void submit(final ITaskFailure<Void> failure, Throwable error) {
        if (failure == null) {
            log.info("Failure is null");
            return;
        }
        this.checkItems();
        FailureType type = failure.getFailureType(error);
        if (type == FailureType.UNRECOVERABLE) {
            if (DEBUG) {
                System.out.println("Task failure " + failure.getTaskId() + " has exception " + error + " that is a fatal failure. Running onFatal...");
            }
            failure.onFatal();
            this.items.remove(failure.getTaskId());
        } else if (type == FailureType.RECOVERABLE) {
            FailureItem item = this.items.get(failure.getTaskId());
            if (item == null) {
                item = new FailureItem();
                this.items.put(failure.getTaskId(), item);
            }
            int count = item.increaseCount();
            if (DEBUG) {
                System.out.println("Task failure " + failure.getTaskId() + " has count " + count);
            }
            if (count >= this.tolerance) {
                if (DEBUG) {
                    System.out.println("Task failure " + failure.getTaskId() + " is unrecoverable. Running onFatal...");
                }
                failure.onFatal();
                this.items.remove(failure.getTaskId());
            } else if (failure.getTask() != null) {
                if (DEBUG) {
                    System.out.println("Task failure " + failure.getTaskId() + " is recoverable. Scheduling retry...");
                }
                final Callable<Void> task = failure.getTask();
                Runnable realTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            task.call();
                        }
                        catch (Exception e) {
                            log.info("Retry task with exception " + StringUtils.getErrorMessage(e), (Throwable)e);
                            FailureRecoverManagement.this.submit(failure, e);
                        }
                    }
                };
                this.executor.schedule(realTask, this.retryInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public <E> E evaluate(ITaskFailure<E> failure, Throwable error) {
        if (failure == null) {
            log.info("Failure is null");
            return null;
        }
        this.checkItems();
        FailureType type = failure.getFailureType(error);
        if (type == FailureType.UNRECOVERABLE) {
            if (DEBUG) {
                System.out.println("Task failure " + failure.getTaskId() + " has exception " + error + " that is a fatal failure. Running onFatal...");
            }
            failure.onFatal();
            this.items.remove(failure.getTaskId());
        } else if (type == FailureType.RECOVERABLE) {
            FailureItem item = this.items.get(failure.getTaskId());
            if (item == null) {
                item = new FailureItem();
                this.items.put(failure.getTaskId(), item);
            }
            int count = item.increaseCount();
            if (DEBUG) {
                System.out.println("Task failure " + failure.getTaskId() + " has count " + count);
            }
            if (count >= this.tolerance) {
                if (DEBUG) {
                    System.out.println("Task failure " + failure.getTaskId() + " is unrecoverable. Running onFatal...");
                }
                failure.onFatal();
                this.items.remove(failure.getTaskId());
            } else if (failure.getTask() != null) {
                if (DEBUG) {
                    System.out.println("Task failure " + failure.getTaskId() + " is recoverable. Retrying...");
                }
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Callable<E> task = failure.getTask();
                try {
                    return task.call();
                }
                catch (Exception e) {
                    log.info("Retry task with exception " + StringUtils.getErrorMessage(e), (Throwable)e);
                    return this.evaluate(failure, e);
                }
            }
        }
        return null;
    }

    protected void checkItems() {
        Object[] ids;
        for (Object id : ids = this.items.keySet().toArray()) {
            FailureItem item = this.items.get(id);
            long elapsedTime = item.getElapsedTime();
            if (elapsedTime <= this.memoryLength) continue;
            log.info("Remove old task failure " + id);
            this.items.remove(id);
        }
    }

    @Override
    public void cleanup() throws InterruptedException {
        this.items.clear();
        this.executor.shutdown();
        if (!this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
            log.info("Executor did not terminate in the specified time.");
            List<Runnable> droppedTasks = this.executor.shutdownNow();
            log.info("Executor was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
        }
    }

    private static class FailureItem {
        private int count;
        private long timestamp;

        private FailureItem() {
        }

        public int increaseCount() {
            ++this.count;
            this.timestamp = System.currentTimeMillis();
            return this.count;
        }

        public long getElapsedTime() {
            return System.currentTimeMillis() - this.timestamp;
        }

        public String toString() {
            return "FailureItem [count=" + this.count + ", timestamp=" + this.timestamp + "]";
        }
    }
}

