/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.applications.Application;
import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlValue;

public class BooleanNode
implements IAttribute,
Serializable {
    private static final long serialVersionUID = 8532195493892626199L;
    protected final String type;
    protected boolean isSelected;

    public BooleanNode(String type) {
        this.type = type;
    }

    public BooleanNode(String type, boolean isSelected) {
        this.type = type;
        this.isSelected = isSelected;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @XmlValue
    public void setValue(String value) {
        if (value.equals("1") || value.equalsIgnoreCase("true")) {
            this.isSelected = true;
        } else if (value.equals("0") || value.equalsIgnoreCase("false")) {
            this.isSelected = false;
        } else {
            throw new IllegalArgumentException("Invalid string '" + value + "'");
        }
    }

    public String getValue() {
        return this.isSelected ? "1" : "0";
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public IAttribute copy() {
        return new BooleanNode(this.type, this.isSelected);
    }

    @Override
    public void installApplication(Application app) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void installDevieGroup(DeviceGroup group) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void installVirtualFabric(VirtualFabric vf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void installQOSGroup(QOSGroup qosgroup) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isSelected ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanNode other = (BooleanNode)obj;
        if (this.isSelected != other.isSelected) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "BooleanNode [type=" + this.type + ", isSelected=" + this.isSelected + "]";
    }
}

