/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.HostType;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.common.SshSession;
import com.intel.stl.fecdriver.network.ssh.JSchChannelType;
import com.intel.stl.fecdriver.network.ssh.SshKeyType;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSession;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSessionFactory;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMConfHelper {
    private static final Logger log = LoggerFactory.getLogger(FMConfHelper.class);
    public static final String OLD_HSM_CFGPATH = "/etc/sysconfig/";
    public static final String HSM_CFGPATH = "/etc/opa-fm/";
    public static final String ESM_CFGPATH = "/firmware/";
    private static final String AUTO_GEN_ID = "<!-- Generated file. Do not edit. -->";
    private static final String CONFIG_TAG = "<Config>";
    private static Map<SubnetDescription, FMConfHelper> helperMap = new HashMap<SubnetDescription, FMConfHelper>();
    protected static final String CONF = "opafm.xml";
    protected static final int NUM_BACKUPS = 16;
    protected final SubnetDescription subnet;
    protected int[] fmVersion;
    protected File tmpConfFile;
    private Boolean editable;

    public static FMConfHelper getInstance(SubnetDescription subnet) {
        FMConfHelper helper = helperMap.get(subnet);
        if (helper == null) {
            helper = new FMConfHelper(subnet);
            helperMap.put(subnet, helper);
        }
        return helper;
    }

    protected FMConfHelper(SubnetDescription subnet) {
        this.subnet = subnet;
    }

    public String getHost() {
        return this.subnet.getCurrentFE().getHost();
    }

    public boolean isEditable() {
        if (this.editable == null) {
            this.editable = true;
            if (this.tmpConfFile != null) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(this.tmpConfFile));
                    String line = br.readLine();
                    while (line != null) {
                        if ((line = line.trim()).equals(AUTO_GEN_ID)) {
                            this.editable = false;
                            break;
                        }
                        if (line.equals(CONFIG_TAG)) {
                            break;
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return this.editable;
    }

    public synchronized void reset() {
        this.tmpConfFile = null;
        this.editable = null;
    }

    public synchronized File getConfFile() {
        return this.tmpConfFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deployConf(char[] password) throws Exception {
        if (this.tmpConfFile == null) {
            return;
        }
        HostInfo hostInfo = this.subnet.getCurrentFE();
        HostType hostType = hostInfo.getHostType();
        Session session = this.createSession(hostInfo, password);
        String host = hostInfo.getHost();
        String userName = hostInfo.getSshUserName();
        session.connect();
        try {
            switch (hostType) {
                case HSM: {
                    this.deployHSM(host, userName, session);
                    return;
                }
                case ESM: {
                    this.deployESM(session);
                    return;
                }
            }
            return;
        }
        finally {
            session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployHSM(String host, String userName, Session session) throws JSchException, SftpException, IOException {
        this.uploadFile(this.tmpConfFile.getAbsolutePath(), this.getConfigLocation(HostType.HSM), this.tmpConfFile.getName(), session);
        String cmd = this.getShellScript();
        log.info("execute command @ " + host + " \"" + cmd + "\"");
        Channel channel = session.openChannel("exec");
        try {
            ((ChannelExec)channel).setCommand(cmd);
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            InputStream in = channel.getInputStream();
            channel.connect();
            this.waitForExecution(in, channel);
            this.subnet.setCurrentUser(userName);
        }
        finally {
            channel.disconnect();
        }
    }

    private void deployESM(Session session) throws SftpException, JSchException {
        this.uploadFile(this.tmpConfFile.getAbsolutePath(), this.getConfigLocation(HostType.ESM), CONF, session);
    }

    protected Session createSession(HostInfo hostInfo, char[] password) throws JSchException {
        String host = hostInfo.getHost();
        String userName = hostInfo.getSshUserName();
        int port = hostInfo.getSshPortNum();
        JSch jsch = Utils.createJSch();
        Session session = jsch.getSession(userName, host, port);
        session.setPassword(new String(password));
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
        session.setConfig(config);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(String localFile, String remoteFolder, String remoteFile, Session session) throws SftpException, JSchException {
        Channel channel = session.openChannel(JSchChannelType.SFTP_CHANNEL.getValue());
        String host = session.getHost();
        channel.connect();
        try {
            ChannelSftp channelSftp = (ChannelSftp)channel;
            log.info("Upload {} to {}:{}{}", new Object[]{localFile, host, remoteFolder, remoteFile});
            channelSftp.cd(remoteFolder);
            channelSftp.put(localFile, remoteFile);
        }
        finally {
            channel.disconnect();
        }
    }

    public synchronized void restartFM() {
    }

    protected String getShellScript() {
        return "cd " + this.getConfigLocation(HostType.HSM) + "; cp " + CONF + " " + CONF + ".`date +%Y%m%d%H%M%S-%3N`.fv; mv " + this.tmpConfFile.getName() + " " + CONF + "; chmod 755 " + CONF + "; rm -f `ls -t opafm.xml.??????????????-???.fv | sed 1," + 16 + "d`";
    }

    protected void waitForExecution(InputStream in, Channel channel) throws IOException {
        byte[] tmp = new byte[1024];
        while (true) {
            int i;
            if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) continue;
            if (channel.isClosed()) {
                if (in.available() > 0) continue;
                break;
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        log.info("Command exit-status: " + channel.getExitStatus());
    }

    public boolean checkConfigFilePresense() {
        return this.tmpConfFile != null && this.tmpConfFile.exists();
    }

    public void fetchConfigFile(char[] password) throws Exception {
        HostInfo hostInfo = this.subnet.getCurrentFE();
        String hostName = hostInfo.getHost();
        String userName = hostInfo.getSshUserName();
        JSchSession jschSession = JSchSessionFactory.getSession(this.subnet, false, password, SshKeyType.MANAGEMENT_KEY.getKey(this.subnet.getSubnetId()));
        SshSession ss = jschSession.getSshSession();
        if (ss != null) {
            try {
                this.fmVersion = Utils.getFMVersion(ss);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File tmpFile = File.createTempFile("~FV", null);
        tmpFile.deleteOnExit();
        if (!jschSession.isConnected()) {
            jschSession.shutdown();
            jschSession = JSchSessionFactory.getSession(this.subnet, false, password, SshKeyType.MANAGEMENT_KEY.getKey(this.subnet.getSubnetId()));
        }
        ChannelSftp sftpChannel = jschSession.getSFtpChannel();
        sftpChannel.connect();
        HostType hostType = this.determineHostType(sftpChannel);
        hostInfo.setHostType(hostType);
        try {
            sftpChannel.get(CONF, tmpFile.getAbsolutePath());
            log.info("Download {}:{}{} to {} (size={})", new Object[]{hostName, this.getConfigLocation(hostType), CONF, tmpFile.getAbsolutePath(), tmpFile.length()});
            this.subnet.setCurrentUser(userName);
            this.tmpConfFile = tmpFile;
        }
        catch (SftpException e) {
            throw new SftpException(e.id, STLMessages.STL61020_SFTP_FAILURE.getDescription(this.getConfigLocation(hostType) + CONF, StringUtils.getErrorMessage(e)), e.getCause());
        }
        finally {
            sftpChannel.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancelFetchConfigFile(SubnetDescription subnet) {
        JSchSession subnetSession = JSchSessionFactory.getSessionFromMap(SshKeyType.MANAGEMENT_KEY.getKey(subnet.getSubnetId()));
        if (subnetSession != null) {
            ChannelSftp sftp = null;
            try {
                sftp = subnetSession.getSFtpChannel();
                if (sftp == null) return;
                sftp.disconnect();
                return;
            }
            catch (JSchException e) {
                e.printStackTrace();
                return;
            }
            finally {
                subnetSession.disconnect();
            }
        } else {
            log.info("cancelFetchConfigFile(): subnetSession is not in the map yet");
        }
    }

    protected HostType determineHostType(ChannelSftp sftpChannel) {
        HostType hostType = HostType.UNKNOWN;
        HostType[] hostTypes = HostType.values();
        for (int i = 0; i < hostTypes.length; ++i) {
            try {
                sftpChannel.cd(this.getConfigLocation(hostTypes[i]));
                hostType = hostTypes[i];
                break;
            }
            catch (SftpException sftpException) {
                continue;
            }
        }
        return hostType;
    }

    protected String getConfigLocation(HostType type) {
        if (type == HostType.ESM) {
            return ESM_CFGPATH;
        }
        if (type == HostType.HSM) {
            if (this.fmVersion == null || this.fmVersion[0] == 10 && this.fmVersion[1] <= 3) {
                return OLD_HSM_CFGPATH;
            }
            return HSM_CFGPATH;
        }
        return "";
    }
}

