/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.applications;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.management.applications.ServiceID;

public class ServiceIDRange
extends ServiceID {
    private static final long serialVersionUID = -6553489373182562951L;
    private long max;

    public ServiceIDRange() {
        this(0L, 0L);
    }

    public ServiceIDRange(long min, long max) {
        super("ServiceIDRange", min);
        this.max = max;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.getId();
    }

    @Override
    public void setValue(String val) {
        try {
            String[] segs = val.split("-");
            super.setValue(segs[0]);
            if (segs.length > 0) {
                this.max = Utils.toLong(segs[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceIDRange other = (ServiceIDRange)obj;
        return this.max == other.max;
    }

    @Override
    public ServiceIDRange copy() {
        ServiceIDRange res = new ServiceIDRange(this.getId(), this.max);
        return res;
    }

    @Override
    public String toString() {
        return super.toString() + "-" + StringUtils.longHexString(this.max);
    }
}

