/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.impl;

import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.management.TmpFmConfHelper;
import com.intel.stl.api.management.applications.Application;
import com.intel.stl.api.management.applications.ApplicationException;
import com.intel.stl.api.management.applications.impl.ApplicationManagement;
import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.api.management.devicegroups.DeviceGroupException;
import com.intel.stl.api.management.devicegroups.impl.DeviceGroupManagement;
import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.api.management.qosgroups.QOSGroupException;
import com.intel.stl.api.management.qosgroups.impl.QOSGroupManagement;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.api.management.virtualfabrics.VirtualFabricException;
import com.intel.stl.api.management.virtualfabrics.impl.VirtualFabricManagement;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.fecdriver.network.ssh.SshKeyType;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSession;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSessionFactory;
import java.util.List;
import java.util.Set;

public class ManagementApi
implements IManagementApi {
    private final FMConfHelper confHelper;
    private final ApplicationManagement appMgt;
    private final DeviceGroupManagement groupMgt;
    private final VirtualFabricManagement vfMgt;
    private final QOSGroupManagement qosMgt;
    private final SubnetDescription subnet;

    public ManagementApi(SubnetDescription subnet) {
        this.confHelper = FMConfHelper.getInstance(subnet);
        this.appMgt = new ApplicationManagement(this.confHelper);
        this.groupMgt = new DeviceGroupManagement(this.confHelper);
        this.vfMgt = new VirtualFabricManagement(this.confHelper);
        this.qosMgt = new QOSGroupManagement(this.confHelper);
        this.subnet = subnet;
    }

    @Override
    public boolean isEdiatble() {
        if (this.confHelper != null) {
            return this.confHelper.isEditable();
        }
        return false;
    }

    @Override
    public void reset() {
        this.confHelper.reset();
        this.appMgt.reset();
        this.groupMgt.reset();
        this.vfMgt.reset();
        this.qosMgt.reset();
    }

    @Override
    public boolean hasChanges() {
        return this.appMgt.hasChanges() || this.groupMgt.hasChanges() || this.vfMgt.hasChanges() || this.qosMgt.hasChanges();
    }

    @Override
    public void deploy(char[] password, boolean restart) throws Exception {
        this.confHelper.deployConf(password);
    }

    @Override
    public void deployTo(char[] password, HostInfo target) throws Exception {
        TmpFmConfHelper tmpConfHelper = new TmpFmConfHelper(target);
        ((FMConfHelper)tmpConfHelper).fetchConfigFile(password);
        ApplicationManagement tmpAppMgt = new ApplicationManagement(tmpConfHelper);
        this.appMgt.applyChangesTo(tmpAppMgt);
        DeviceGroupManagement tmpGroupMgt = new DeviceGroupManagement(tmpConfHelper);
        this.groupMgt.applyChangesTo(tmpGroupMgt);
        VirtualFabricManagement tmpVfMgt = new VirtualFabricManagement(tmpConfHelper);
        this.vfMgt.applyChangesTo(tmpVfMgt);
        QOSGroupManagement tmpQOSMgt = new QOSGroupManagement(tmpConfHelper);
        if (tmpQOSMgt.supportQOSGroup()) {
            this.qosMgt.applyChangesTo(tmpQOSMgt);
        }
        tmpConfHelper.deployConf(password);
    }

    @Override
    public Set<String> getReservedApplications() {
        return this.appMgt.getReservedApplications();
    }

    @Override
    public List<Application> getApplications() throws ApplicationException {
        return this.appMgt.getApplications();
    }

    @Override
    public Application getApplication(String name) throws ApplicationException {
        return this.appMgt.getApplication(name);
    }

    @Override
    public void addApplication(Application app) throws ApplicationException {
        this.appMgt.addApplication(app);
    }

    @Override
    public void removeApplication(String appName) throws ApplicationException {
        this.appMgt.removeApplication(appName);
    }

    @Override
    public void updateApplication(String oldName, Application app) throws ApplicationException {
        this.appMgt.updateApplication(oldName, app);
    }

    @Override
    public void addOrUpdateApplication(String oldName, Application app) throws ApplicationException {
        this.appMgt.addOrUpdateApplication(oldName, app);
    }

    @Override
    public Set<String> getReservedDeviceGroups() {
        return this.groupMgt.getReservedDeviceGroups();
    }

    @Override
    public List<DeviceGroup> getDeviceGroups() throws DeviceGroupException {
        return this.groupMgt.getDeviceGroups();
    }

    @Override
    public DeviceGroup getDeviceGroup(String name) throws DeviceGroupException {
        return this.groupMgt.getDeviceGroup(name);
    }

    @Override
    public void addDeviceGroup(DeviceGroup group) throws DeviceGroupException {
        this.groupMgt.addDeviceGroup(group);
    }

    @Override
    public void removeDeviceGroup(String name) throws DeviceGroupException {
        this.groupMgt.removeDeviceGroup(name);
    }

    @Override
    public void updateDeviceGroup(String oldName, DeviceGroup group) throws DeviceGroupException {
        this.groupMgt.updateDeviceGroup(oldName, group);
    }

    @Override
    public void addOrUpdateDeviceGroup(String oldName, DeviceGroup group) throws DeviceGroupException {
        this.groupMgt.addOrUpdateDeviceGroup(oldName, group);
    }

    @Override
    public Set<String> getReservedVirtualFabrics() {
        return this.vfMgt.getReservedVirtualFabrics();
    }

    @Override
    public List<VirtualFabric> getVirtualFabrics() throws VirtualFabricException {
        return this.vfMgt.getVirtualFabrics();
    }

    @Override
    public VirtualFabric getVirtualFabric(String name) throws VirtualFabricException {
        return this.vfMgt.getVirtualFabric(name);
    }

    @Override
    public void addVirtualFabric(VirtualFabric vf) throws VirtualFabricException {
        this.vfMgt.addVirtualFabric(vf);
    }

    @Override
    public void removeVirtualFabric(String name) throws VirtualFabricException {
        this.vfMgt.removeVirtualFabric(name);
    }

    @Override
    public void updateVirtualFabric(String oldName, VirtualFabric vf) throws VirtualFabricException {
        this.vfMgt.updateVirtualFabric(oldName, vf);
    }

    @Override
    public void addOrUpdateVirtualFabric(String oldName, VirtualFabric vf) throws VirtualFabricException {
        this.vfMgt.addOrUpdateVirtualFabric(oldName, vf);
    }

    @Override
    public boolean supportQOSGroup() {
        return this.qosMgt.supportQOSGroup();
    }

    @Override
    public Set<String> getReservedQOSGroups() {
        return this.qosMgt.getReservedQOSGroups();
    }

    @Override
    public List<QOSGroup> getQOSGroups() throws QOSGroupException {
        return this.qosMgt.getQOSGroups();
    }

    @Override
    public QOSGroup getQOSGroup(String name) throws QOSGroupException {
        return this.qosMgt.getQOSGroup(name);
    }

    @Override
    public void addQOSGroup(QOSGroup app) throws QOSGroupException {
        this.qosMgt.addQOSGroup(app);
    }

    @Override
    public void removeQOSGroup(String qosName) throws QOSGroupException {
        this.qosMgt.removeQOSGroup(qosName);
    }

    @Override
    public void updateQOSGroup(String oldName, QOSGroup qos) throws QOSGroupException {
        this.qosMgt.updateQOSGroup(oldName, qos);
    }

    @Override
    public void addOrUpdateQOSGroup(String oldName, QOSGroup qos) throws QOSGroupException {
        this.qosMgt.addOrUpdateQOSGroup(oldName, qos);
    }

    @Override
    public SubnetDescription getSubnetDescription() {
        return this.subnet;
    }

    @Override
    public boolean isConfigReady() {
        return this.confHelper.checkConfigFilePresense();
    }

    @Override
    public boolean hasSession() {
        boolean connectionStatus = false;
        JSchSession session = JSchSessionFactory.getSessionFromMap(SshKeyType.MANAGEMENT_KEY.getKey(this.subnet.getSubnetId()));
        if (session != null) {
            connectionStatus = session.isConnected();
        }
        return connectionStatus;
    }

    @Override
    public void fetchConfigFile(char[] password) throws Exception {
        this.confHelper.fetchConfigFile(password);
    }

    @Override
    public void onCancelFetchConfig(SubnetDescription subnet) {
        this.confHelper.cancelFetchConfigFile(subnet);
    }

    @Override
    public void cleanup() {
        this.subnet.getCurrentFE().setHostType(null);
        JSchSessionFactory.closeSession(SshKeyType.MANAGEMENT_KEY.getKey(this.subnet.getSubnetId()));
        this.confHelper.reset();
    }
}

