/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.qosgroups.impl;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.ChangeManager;
import com.intel.stl.api.management.DuplicateBaseSLException;
import com.intel.stl.api.management.DuplicateNameException;
import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.api.management.XMLUtils;
import com.intel.stl.api.management.qosgroups.IQOSGroupManagement;
import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.api.management.qosgroups.QOSGroupException;
import com.intel.stl.api.management.qosgroups.QOSGroups;
import com.intel.stl.api.management.virtualfabrics.BaseSL;
import com.intel.stl.common.STLMessages;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QOSGroupManagement
implements IQOSGroupManagement {
    private static final Logger log = LoggerFactory.getLogger(QOSGroupManagement.class);
    private static final Set<String> RESERVED = new HashSet<String>(){
        private static final long serialVersionUID = 1112569917279950166L;
        {
            this.add("Networking");
            this.add("LowPriority");
            this.add("HighPriority");
        }
    };
    private Boolean supportQOSGroup = null;
    private final FMConfHelper confHelp;
    private final ChangeManager changeMgr = new ChangeManager();

    public QOSGroupManagement(FMConfHelper confHelp) {
        this.confHelp = confHelp;
    }

    @Override
    public boolean supportQOSGroup() {
        if (this.supportQOSGroup == null) {
            this.supportQOSGroup = false;
            try {
                XMLStreamReader xsr = this.getQOSGroupStreamReader(this.confHelp.getConfFile());
                if (xsr != null) {
                    try {
                        this.supportQOSGroup = this.getQOSGroups() != null;
                    }
                    catch (QOSGroupException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
        return this.supportQOSGroup;
    }

    @Override
    public Set<String> getReservedQOSGroups() {
        return RESERVED;
    }

    @Override
    public synchronized List<QOSGroup> getQOSGroups() throws QOSGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            QOSGroups groups = this.unmarshal(confFile);
            List<QOSGroup> groupList = groups.getQosGroups();
            log.info("Fetch " + (groupList == null ? "0" : Integer.valueOf(groupList.size())) + " QOSGroups from host '" + this.confHelp.getHost() + "'");
            return groupList;
        }
        catch (Exception e) {
            throw this.createQOSGroupException(STLMessages.STL63031_GET_QOSGS_ERR, e, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    @Override
    public synchronized QOSGroup getQOSGroup(String name) throws QOSGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            QOSGroups groups = this.unmarshal(confFile);
            return groups.getQOSGroup(name);
        }
        catch (Exception e) {
            throw this.createQOSGroupException(STLMessages.STL63036_GET_QOSG_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected QOSGroups unmarshal(File xmlFile) throws XMLStreamException, JAXBException {
        XMLStreamReader xsr = this.getQOSGroupStreamReader(xmlFile);
        if (xsr == null) {
            throw new UnsupportedOperationException(STLMessages.STL63037_NO_SUPPORT_QOSG.getDescription());
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{QOSGroups.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        JAXBElement jb = unmarshaller.unmarshal(xsr, QOSGroups.class);
        xsr.close();
        return (QOSGroups)jb.getValue();
    }

    protected XMLStreamReader getQOSGroupStreamReader(File xmlFile) throws XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        StreamSource xml = new StreamSource(xmlFile);
        XMLStreamReader xsr = xif.createXMLStreamReader(xml);
        while (!(!xsr.hasNext() || xsr.isStartElement() && xsr.getLocalName().equals("QOSGroups"))) {
            xsr.next();
        }
        if (xsr.hasNext()) {
            return xsr;
        }
        return null;
    }

    @Override
    public synchronized void addQOSGroup(QOSGroup group) throws QOSGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.uniqueNameCheck(null, group.getName());
            this.uniqueBaseSLCheck(null, group.getBaseSL());
            this.addQOSGroup(confFile, confFile, group);
            log.info("Added QOSGroup " + group);
            this.changeMgr.addChange(group.getName());
        }
        catch (Exception e) {
            throw this.createQOSGroupException(STLMessages.STL63032_ADD_QOSGS_ERR, e, group.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void addQOSGroup(File srcXml, File dstXml, QOSGroup group) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{group.getClass()});
        context.createMarshaller().marshal((Object)group, (Result)res);
        Document appsDoc = (Document)res.getNode();
        Node newApp = appsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node groupsNode = doc.getElementsByTagName("QOSGroups").item(0);
        Node matchedApp = this.getQOSGroupByName(groupsNode, group.getName());
        if (matchedApp != null) {
            throw new IllegalArgumentException("QOSGroup '" + group.getName() + "' alreday exist!");
        }
        XMLUtils.appendNode(doc, groupsNode, newApp);
        XMLUtils.writeDoc(doc, dstXml);
    }

    @Override
    public synchronized void removeQOSGroup(String name) throws QOSGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.removeQOSGroup(confFile, confFile, name);
            log.info("Removed QOSGroup '" + name + "'");
            this.changeMgr.addChange(name);
        }
        catch (Exception e) {
            throw this.createQOSGroupException(STLMessages.STL63033_REMOVE_QOSGS_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void removeQOSGroup(File srcXml, File dstXml, String name) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node groupsNod = doc.getElementsByTagName("QOSGroups").item(0);
        Node matchedGroup = this.getQOSGroupByName(groupsNod, name);
        if (matchedGroup != null) {
            XMLUtils.removeNode(doc, groupsNod, matchedGroup, name);
            XMLUtils.writeDoc(doc, dstXml);
        } else {
            log.warn("Couldn't find QOSGroup '" + name + "'");
        }
    }

    @Override
    public synchronized void updateQOSGroup(String oldName, QOSGroup qos) throws QOSGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            if (!oldName.equals(qos.getName())) {
                QOSGroups groups = this.unmarshal(confFile);
                this.uniqueNameCheck(groups, qos.getName());
                this.uniqueBaseSLCheck(groups, qos.getBaseSL());
            }
            this.updateQOSGroup(confFile, confFile, oldName, qos, false);
            log.info("Updated application " + qos);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(qos.getName());
        }
        catch (Exception e) {
            throw this.createQOSGroupException(STLMessages.STL63034_UPDATE_QOSGS_ERR, e, qos.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateQOSGroup(File srcXml, File dstXml, String oldName, QOSGroup group, boolean allowAdd) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{group.getClass()});
        context.createMarshaller().marshal((Object)group, (Result)res);
        Document appsDoc = (Document)res.getNode();
        Node newApp = appsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        doc.adoptNode(newApp);
        Node groupsNode = doc.getElementsByTagName("QOSGroups").item(0);
        Node matchedQOSGroup = this.getQOSGroupByName(groupsNode, oldName);
        if (matchedQOSGroup == null) {
            if (!allowAdd) throw new IllegalArgumentException("Couldn't find QOSGroup '" + oldName + "'");
            XMLUtils.appendNode(doc, groupsNode, newApp);
        } else {
            XMLUtils.replaceNode(doc, groupsNode, matchedQOSGroup, newApp);
        }
        XMLUtils.writeDoc(doc, dstXml);
    }

    @Override
    public synchronized void addOrUpdateQOSGroup(String oldName, QOSGroup qos) throws QOSGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            if (!oldName.equals(qos.getName())) {
                QOSGroups groups = this.unmarshal(confFile);
                this.uniqueNameCheck(groups, qos.getName());
            }
            this.updateQOSGroup(confFile, confFile, oldName, qos, true);
            log.info("Added or updated QOSGroup " + qos);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(qos.getName());
        }
        catch (Exception e) {
            throw this.createQOSGroupException(STLMessages.STL63035_ADDUPDATE_QOSGS_ERR, e, qos.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void uniqueNameCheck(QOSGroups groups, String name) throws Exception {
        if (groups == null) {
            File confFile = this.confHelp.getConfFile();
            groups = this.unmarshal(confFile);
        }
        for (QOSGroup group : groups.getQosGroups()) {
            if (!group.getName().equals(name)) continue;
            throw new DuplicateNameException(name);
        }
    }

    protected void uniqueBaseSLCheck(QOSGroups groups, BaseSL baseSL) throws Exception {
        if (groups == null) {
            File confFile = this.confHelp.getConfFile();
            groups = this.unmarshal(confFile);
        }
        if (baseSL != null) {
            for (QOSGroup group : groups.getQosGroups()) {
                if (!baseSL.equals(group.getBaseSL())) continue;
                throw new DuplicateBaseSLException(baseSL);
            }
        }
    }

    private Node getQOSGroupByName(Node groupsNode, String name) {
        NodeList children = groupsNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node nameNode;
            Node child = children.item(i);
            if (!child.getNodeName().equals("QOSGroup") || (nameNode = XMLUtils.getNodeByName(child, "Name")) == null || !nameNode.getTextContent().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected QOSGroupException createQOSGroupException(IMessage msg, Throwable error, Object ... args) {
        return new QOSGroupException(msg, error, args);
    }

    public boolean hasChanges() {
        return !this.changeMgr.getChanges().isEmpty();
    }

    public void applyChangesTo(QOSGroupManagement target) throws QOSGroupException {
        List<QOSGroup> groups = this.getQOSGroups();
        HashMap<String, QOSGroup> map = new HashMap<String, QOSGroup>();
        for (QOSGroup app : groups) {
            map.put(app.getName(), app);
        }
        for (String change : this.changeMgr.getChanges()) {
            QOSGroup cur = (QOSGroup)map.get(change);
            if (cur == null) {
                target.removeQOSGroup(change);
                continue;
            }
            target.addOrUpdateQOSGroup(change, cur);
        }
        this.changeMgr.resetChanges();
    }

    public void reset() {
        this.supportQOSGroup = null;
        this.changeMgr.resetChanges();
    }
}

