/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.virtualfabrics;

import com.intel.stl.api.management.WrapperNode;
import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import java.text.NumberFormat;

public class Bandwidth
extends WrapperNode<Double> {
    private static final long serialVersionUID = 3254223451844225287L;
    private static final NumberFormat format = NumberFormat.getPercentInstance();

    public Bandwidth() {
        this(null);
    }

    public Bandwidth(Double value) {
        super("Bandwidth", value);
    }

    @Override
    protected Double valueOf(String str) {
        Double res = null;
        if (str.charAt(str.length() - 1) == '%') {
            res = Double.parseDouble(str.substring(0, str.length() - 1));
            if (res >= 1.0 && res <= 100.0) {
                return res / 100.0;
            }
            throw new IllegalArgumentException("Invalid value range '" + str + "'. Expect value in 1-100%");
        }
        throw new IllegalArgumentException("Invalid format '" + str + "'. Expect value in 1-100%");
    }

    @Override
    protected String valueString(Double value) {
        return format.format(value);
    }

    @Override
    public Bandwidth copy() {
        return new Bandwidth((Double)this.value);
    }

    public String toString() {
        return "Bandwidth [type=" + this.type + ", value=" + this.value + "]";
    }

    @Override
    public void installVirtualFabric(VirtualFabric vf) {
        vf.setBandwidth(this);
    }

    @Override
    public void installQOSGroup(QOSGroup qosgroup) {
        qosgroup.setBandwidth(this);
    }
}

