/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.notice;

import com.intel.stl.api.notice.NoticeType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NoticeSeverity {
    INFO(0),
    WARNING(1),
    ERROR(2),
    CRITICAL(3);

    private static final Map<String, NoticeSeverity> severityMap;
    private static Logger log;
    private final int id;

    private NoticeSeverity(int id) {
        this.id = id;
    }

    public static NoticeSeverity getNoticeSeverity(NoticeType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case FATAL: {
                return CRITICAL;
            }
            case URGENT: {
                return ERROR;
            }
            case SECURITY: {
                return WARNING;
            }
            case SM: {
                return WARNING;
            }
            case INFO: {
                return INFO;
            }
        }
        log.warn("Unknown NotieType " + (Object)((Object)type));
        return null;
    }

    public static NoticeSeverity getNoticeSeverity(byte type) {
        return NoticeSeverity.getNoticeSeverity(NoticeType.getNoticeType(type));
    }

    public static NoticeSeverity getNoticeSeverity(int id) {
        NoticeSeverity severity = null;
        switch (id) {
            case 0: {
                severity = INFO;
                break;
            }
            case 1: {
                severity = WARNING;
                break;
            }
            case 2: {
                severity = ERROR;
                break;
            }
            case 3: {
                severity = CRITICAL;
            }
        }
        return severity;
    }

    public int getId() {
        return this.id;
    }

    public static NoticeSeverity getNoticeSeverity(String severityName) {
        return severityMap.get(severityName);
    }

    static {
        severityMap = new HashMap<String, NoticeSeverity>();
        for (NoticeSeverity severity : NoticeSeverity.values()) {
            severityMap.put(severity.name(), severity);
        }
        log = LoggerFactory.getLogger(NoticeSeverity.class);
    }
}

