/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.notice.impl;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.notice.GenericNoticeAttrBean;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.NoticeWrapper;
import com.intel.stl.api.notice.TrapType;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.api.subnet.DefaultDeviceGroup;
import com.intel.stl.api.subnet.GIDBean;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.datamanager.NoticeStatus;
import com.intel.stl.fecdriver.messages.adapter.sa.trap.TrapDetail;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeProcessTask
extends AsyncTask<Future<Boolean>> {
    private static Logger log = LoggerFactory.getLogger(NoticeProcessTask.class);
    private final DatabaseManager dbMgr;
    private final String subnetName;
    private final CacheManager cacheMgr;
    private final SAHelper helper;
    private List<NoticeWrapper> noticeWrappers;

    public NoticeProcessTask(String subnetName, DatabaseManager dbMgr, CacheManager cacheMgr) {
        this.dbMgr = dbMgr;
        this.subnetName = subnetName;
        this.cacheMgr = cacheMgr;
        this.helper = cacheMgr.getSAHelper();
        this.noticeWrappers = new ArrayList<NoticeWrapper>();
    }

    public List<NoticeWrapper> getNoticeWrappers() {
        return this.noticeWrappers;
    }

    @Override
    public Future<Boolean> process() throws Exception {
        boolean success;
        this.dbMgr.getTopologyId(this.subnetName);
        List<NoticeBean> notices = this.dbMgr.getNotices(this.subnetName, NoticeStatus.RECEIVED, NoticeStatus.INFLIGHT);
        log.info("Retrieving " + notices.size() + " notices in the background for subnet: " + this.subnetName);
        if (notices.size() == 0) {
            log.info("No notices to process for subnet: " + this.subnetName);
            return null;
        }
        long t = System.currentTimeMillis();
        try {
            success = this.waitPM();
        }
        catch (Exception e) {
            success = false;
        }
        log.info("waited " + (System.currentTimeMillis() - t) + " ms for PM. State: success=" + success);
        this.noticeWrappers = new ArrayList<NoticeWrapper>(notices.size());
        for (NoticeBean notice : notices) {
            NoticeWrapper nw = this.prepareNotice(notice);
            this.noticeWrappers.add(nw);
        }
        List<NoticeProcess> noticePrcs = this.createNoticeProcesses(this.noticeWrappers);
        Future<Boolean> result = this.dbMgr.processNotices(this.subnetName, noticePrcs);
        for (NoticeProcess noticeProcess : noticePrcs) {
            try {
                this.cacheMgr.updateCaches(noticeProcess);
                if (noticeProcess.getNotice() == null) continue;
                this.dbMgr.updateNotice(this.subnetName, noticeProcess.getNotice().getId(), NoticeStatus.PROCESSED);
            }
            catch (Exception e) {
                log.error("Error while updating caches for notice " + noticeProcess.getNotice().getId() + ": " + noticeProcess.getNotice(), (Throwable)e);
                if (noticeProcess.getNotice() == null) continue;
                this.dbMgr.updateNotice(this.subnetName, noticeProcess.getNotice().getId(), NoticeStatus.FEERROR);
            }
        }
        log.info("Notices have been processed");
        return result;
    }

    private NoticeWrapper prepareNotice(NoticeBean notice) {
        TrapType trapType = this.getTrapType(notice);
        NoticeWrapper nw = new NoticeWrapper(notice, trapType);
        long guid = -1L;
        int lid = -1;
        NodeRecordBean node = null;
        try {
            switch (trapType) {
                case GID_NOW_IN_SERVICE: {
                    GIDBean gid = TrapDetail.getGID(notice.getData());
                    guid = gid.getInterfaceID();
                    node = this.helper.getNode(guid);
                    if (node == null) break;
                    lid = node.getLid();
                    List<LinkRecordBean> links = this.helper.getLinks(lid);
                    nw.addRelatedNodes(this.getRelatedNodes(links));
                    break;
                }
                case GID_OUT_OF_SERVICE: {
                    GIDBean gid = TrapDetail.getGID(notice.getData());
                    guid = gid.getInterfaceID();
                    node = this.dbMgr.getNode(this.subnetName, guid);
                    if (node == null) break;
                    lid = node.getLid();
                    LinkRecordBean link = this.dbMgr.getLinkBySource(this.subnetName, lid, (short)1);
                    nw.addRelatedNode(link.getToLID());
                    break;
                }
                case LINK_PORT_CHANGE_STATE: {
                    lid = TrapDetail.getLid(notice.getData());
                    node = this.helper.getNode(lid);
                    List<LinkRecordBean> links = this.dbMgr.getLinks(this.subnetName, lid);
                    nw.addRelatedNodes(this.getRelatedNodes(links));
                    links = this.helper.getLinks(lid);
                    nw.addRelatedNodes(this.getRelatedNodes(links));
                    break;
                }
                case FE_CONNECTION_LOST: 
                case FE_CONNECTION_ESTABLISH: {
                    break;
                }
                default: {
                    log.warn("Unsupported notice " + notice);
                }
            }
            if (node == null) {
                if (lid >= 0) {
                    log.warn("Node information not found in FM or DB for GUID=" + StringUtils.longHexString(guid) + " or LID=" + lid + " mentioned in notice: " + notice);
                }
                this.dbMgr.updateNotice(this.subnetName, notice.getId(), NoticeStatus.FEERROR);
            }
        }
        catch (Exception e) {
            log.error("Error while preparing notice " + notice.getId() + ": " + notice, (Throwable)e);
            this.dbMgr.updateNotice(this.subnetName, notice.getId(), NoticeStatus.FEERROR);
        }
        nw.setNode(node);
        return nw;
    }

    private List<NoticeProcess> createNoticeProcesses(List<NoticeWrapper> noticeWrappers) {
        ArrayList<NoticeProcess> noticePrcs = new ArrayList<NoticeProcess>();
        for (NoticeWrapper nw : noticeWrappers) {
            try {
                NodeRecordBean node = nw.getNode();
                if (node == null) continue;
                NoticeProcess np = this.createNoticeProcess(nw.getNotice(), nw.getTrapType(), node);
                if (np != null) {
                    noticePrcs.add(np);
                }
                for (int relatedLid : nw.getRelatedNodes()) {
                    node = this.helper.getNode(relatedLid);
                    np = this.createNoticeProcess(null, TrapType.LINK_PORT_CHANGE_STATE, node);
                    if (np == null) continue;
                    noticePrcs.add(np);
                }
            }
            catch (Exception e) {
                NoticeBean notice = nw.getNotice();
                log.error("Error while processing notice " + notice.getId() + ": " + notice, (Throwable)e);
                this.dbMgr.updateNotice(this.subnetName, notice.getId(), NoticeStatus.FEERROR);
            }
        }
        return noticePrcs;
    }

    protected Set<Integer> getRelatedNodes(List<LinkRecordBean> links) {
        HashSet<Integer> res = new HashSet<Integer>();
        for (LinkRecordBean link : links) {
            res.add(link.getToLID());
        }
        return res;
    }

    protected NoticeProcess createNoticeProcess(NoticeBean notice, TrapType trapType, NodeRecordBean node) throws Exception {
        NoticeProcess np = new NoticeProcess(notice);
        np.setTrapType(trapType);
        int lid = 0;
        if (node == null) {
            return null;
        }
        lid = node.getLid();
        np.setLid(lid);
        np.setNode(node);
        np.setPorts(this.helper.getPorts(lid));
        np.setLinks(this.helper.getLinks(lid));
        return np;
    }

    private TrapType getTrapType(NoticeBean notice) {
        GenericNoticeAttrBean attr = (GenericNoticeAttrBean)notice.getAttributes();
        return TrapType.getTrapType(attr.getTrapNumber());
    }

    protected boolean waitPM() throws Exception {
        int count;
        PAHelper helper = this.cacheMgr.getPAHelper();
        PMConfigBean conf = helper.getPMConfig();
        int sweep = 0;
        if (conf != null) {
            sweep = conf.getSweepInterval();
        }
        GroupInfoBean gi = helper.getGroupInfo(DefaultDeviceGroup.ALL.getName());
        ImageIdBean image = null;
        if (gi != null) {
            image = gi.getImageId();
        }
        long id = 0L;
        if (image != null) {
            id = image.getImageNumber();
        }
        long imageNumber = id;
        for (count = (int)((double)sweep * 1.1 / 0.2); id == imageNumber && count > 0; --count) {
            Thread.sleep(200L);
            gi = helper.getGroupInfo(DefaultDeviceGroup.ALL.getName());
            if (gi == null || (image = gi.getImageId()) == null) continue;
            imageNumber = image.getImageNumber();
        }
        return count > 0;
    }
}

