/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.Utils;
import com.intel.stl.api.performance.CategoryBucketBean;
import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.api.performance.CategorySummaryBean;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.UtilStatsBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class GroupInfoBean
implements ITimestamped,
Serializable {
    private static final long serialVersionUID = 1L;
    private String groupName;
    private ImageIdBean imageId;
    private long timestamp;
    private int imageInterval;
    private long numInternalPorts;
    private long numExternalPorts;
    private UtilStatsBean internalUtilStats;
    private UtilStatsBean sendUtilStats;
    private UtilStatsBean recvUtilStats;
    private CategorySummaryBean internalCategoryMaximums;
    private List<CategoryBucketBean> internalCategoryStatPorts;
    private CategorySummaryBean externalCategoryMaximums;
    private List<CategoryBucketBean> externalCategoryStatPorts;
    private byte maxInternalRate;
    private byte minInternalRate;
    private byte maxExternalRate;
    private byte minExternalRate;
    private int maxInternalMBps;
    private int maxExternalMBps;

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        if (groupName.length() > 64) {
            throw new IllegalArgumentException("Invalid string length: " + groupName.length() + " > " + 64);
        }
        this.groupName = groupName;
    }

    public ImageIdBean getImageId() {
        return this.imageId;
    }

    public void setImageId(ImageIdBean imageId) {
        this.imageId = imageId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long sweepTimestamp) {
        this.timestamp = sweepTimestamp;
    }

    @Override
    public Date getTimestampDate() {
        return Utils.convertFromUnixTime(this.timestamp);
    }

    @Override
    public int getImageInterval() {
        return this.imageInterval;
    }

    @Override
    public void setImageInterval(int imageInterval) {
        this.imageInterval = imageInterval;
    }

    public long getNumInternalPorts() {
        return this.numInternalPorts;
    }

    public void setNumInternalPorts(long numInternalPorts) {
        this.numInternalPorts = numInternalPorts;
    }

    public void setNumInternalPorts(int numInternalPorts) {
        this.numInternalPorts = Utils.unsignedInt(numInternalPorts);
    }

    public long getNumExternalPorts() {
        return this.numExternalPorts;
    }

    public void setNumExternalPorts(long numExternalPorts) {
        this.numExternalPorts = numExternalPorts;
    }

    public void setNumExternalPorts(int numExternalPorts) {
        this.numExternalPorts = Utils.unsignedInt(numExternalPorts);
    }

    public UtilStatsBean getInternalUtilStats() {
        return this.internalUtilStats;
    }

    public void setInternalUtilStats(UtilStatsBean internalUtilStats) {
        this.internalUtilStats = internalUtilStats;
    }

    public UtilStatsBean getSendUtilStats() {
        return this.sendUtilStats;
    }

    public void setSendUtilStats(UtilStatsBean sendUtilStats) {
        this.sendUtilStats = sendUtilStats;
    }

    public UtilStatsBean getRecvUtilStats() {
        return this.recvUtilStats;
    }

    public void setRecvUtilStats(UtilStatsBean recvUtilStats) {
        this.recvUtilStats = recvUtilStats;
    }

    public CategoryStatBean getInternalCategoryStats() {
        CategoryStatBean internalCategoryStats = new CategoryStatBean();
        internalCategoryStats.setCategoryMaximums(this.internalCategoryMaximums);
        internalCategoryStats.setPorts(this.getInternalCategoryStatPortsAsArray());
        return internalCategoryStats;
    }

    public void setInternalCategoryStats(CategoryStatBean internalCategoryStats) {
        this.internalCategoryMaximums = internalCategoryStats.getCategoryMaximums();
        this.setInternalCategoryStatPorts(internalCategoryStats.getPorts());
    }

    public CategorySummaryBean getInternalCategoryMaximums() {
        return this.internalCategoryMaximums;
    }

    public void setInternalCategoryMaximums(CategorySummaryBean internalCategoryMaximums) {
        this.internalCategoryMaximums = internalCategoryMaximums;
    }

    public CategoryBucketBean[] getInternalCategoryStatPortsAsArray() {
        if (this.internalCategoryStatPorts == null) {
            this.internalCategoryStatPorts = new ArrayList<CategoryBucketBean>();
        }
        CategoryBucketBean[] ebArray = new CategoryBucketBean[this.internalCategoryStatPorts.size()];
        return this.internalCategoryStatPorts.toArray(ebArray);
    }

    public void setInternalCategoryStatPorts(CategoryBucketBean[] internalCategoryStatPorts) {
        ArrayList<CategoryBucketBean> ebList = new ArrayList<CategoryBucketBean>(Arrays.asList(internalCategoryStatPorts));
        this.internalCategoryStatPorts = ebList;
    }

    public List<CategoryBucketBean> getInternalCategoryStatPorts() {
        return this.internalCategoryStatPorts;
    }

    public void setInternalCategoryStatPorts(List<CategoryBucketBean> internalCategoryStatPorts) {
        this.internalCategoryStatPorts = internalCategoryStatPorts;
    }

    public CategoryStatBean getExternalCategoryStats() {
        CategoryStatBean externalCategoryStats = new CategoryStatBean();
        externalCategoryStats.setCategoryMaximums(this.externalCategoryMaximums);
        externalCategoryStats.setPorts(this.getExternalCategoryStatPortsAsArray());
        return externalCategoryStats;
    }

    public void setExternalCategoryStats(CategoryStatBean externalCategoryStats) {
        this.externalCategoryMaximums = externalCategoryStats.getCategoryMaximums();
        this.setExternalCategoryStatPorts(externalCategoryStats.getPorts());
    }

    public CategorySummaryBean getExternalCategoryMaximums() {
        return this.externalCategoryMaximums;
    }

    public void setExternalCategoryMaximums(CategorySummaryBean externalCategoryMaximums) {
        this.externalCategoryMaximums = externalCategoryMaximums;
    }

    public CategoryBucketBean[] getExternalCategoryStatPortsAsArray() {
        if (this.externalCategoryStatPorts == null) {
            this.externalCategoryStatPorts = new ArrayList<CategoryBucketBean>();
        }
        CategoryBucketBean[] ebArray = new CategoryBucketBean[this.externalCategoryStatPorts.size()];
        return this.externalCategoryStatPorts.toArray(ebArray);
    }

    public void setExternalCategoryStatPorts(CategoryBucketBean[] externalErrorPorts) {
        ArrayList<CategoryBucketBean> ebList = new ArrayList<CategoryBucketBean>(Arrays.asList(externalErrorPorts));
        this.externalCategoryStatPorts = ebList;
    }

    public List<CategoryBucketBean> getExternalCategoryStatPorts() {
        return this.externalCategoryStatPorts;
    }

    public void setExternalCategoryStatPorts(List<CategoryBucketBean> externalCategoryStatPorts) {
        this.externalCategoryStatPorts = externalCategoryStatPorts;
    }

    public byte getMaxInternalRate() {
        return this.maxInternalRate;
    }

    public void setMaxInternalRate(byte maxInternalRate) {
        this.maxInternalRate = maxInternalRate;
    }

    public byte getMinInternalRate() {
        return this.minInternalRate;
    }

    public void setMinInternalRate(byte minInternalRate) {
        this.minInternalRate = minInternalRate;
    }

    public byte getMaxExternalRate() {
        return this.maxExternalRate;
    }

    public void setMaxExternalRate(byte maxExternalRate) {
        this.maxExternalRate = maxExternalRate;
    }

    public byte getMinExternalRate() {
        return this.minExternalRate;
    }

    public void setMinExternalRate(byte minExternalRate) {
        this.minExternalRate = minExternalRate;
    }

    public int getMaxInternalMBps() {
        return this.maxInternalMBps;
    }

    public void setMaxInternalMBps(int maxInternalMBps) {
        this.maxInternalMBps = maxInternalMBps;
    }

    public int getMaxExternalMBps() {
        return this.maxExternalMBps;
    }

    public void setMaxExternalMBps(int maxExternalMBps) {
        this.maxExternalMBps = maxExternalMBps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupInfoBean other = (GroupInfoBean)obj;
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        return !(this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId));
    }

    public String toString() {
        return "GroupInfoBean [groupName=" + this.groupName + ", imageId=" + this.imageId + ", numInternalPorts=" + this.numInternalPorts + ", numExternalPorts=" + this.numExternalPorts + ", internalUtilStats=" + this.internalUtilStats + ", sendUtilStats=" + this.sendUtilStats + ", recvUtilStats=" + this.recvUtilStats + ", internalCategoryStats=" + this.getInternalCategoryStats() + ", externalCategoryStats=" + this.getExternalCategoryStats() + ", maxInternalRate=" + this.maxInternalRate + ", minInternalRate=" + this.minInternalRate + ", maxExternalRate=" + this.maxExternalRate + ", minExternalRate=" + this.minExternalRate + ", maxInternalMBps=" + this.maxInternalMBps + ", maxExternalMBps=" + this.maxExternalMBps + "]";
    }
}

