/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance.impl;

import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.Map;
import java.util.Properties;

public class GroupInfoPurgeTask
extends AsyncTask<Integer> {
    protected static final String LAST_GROUPINFO_PURGE = "lastgroupinfopurge-";
    private final DatabaseManager dbMgr;
    private final PAHelper helper;
    private final long ago;

    public GroupInfoPurgeTask(PAHelper helper, DatabaseManager dbMgr, long ago) {
        this.checkArguments(helper, dbMgr, ago);
        this.helper = helper;
        this.dbMgr = dbMgr;
        this.ago = ago;
    }

    @Override
    public Integer process() throws Exception {
        SubnetDescription subnet = this.helper.getSubnetDescription();
        String subnetName = this.helper.getSubnetDescription().getName();
        int deleted = this.dbMgr.purgeGroupInfos(subnetName, this.ago);
        Map<String, Properties> appProps = this.dbMgr.getAppInfo().getPropertiesMap();
        Properties dbProps = appProps.get("Database");
        if (dbProps == null) {
            dbProps = new Properties();
            appProps.put("Database", dbProps);
        }
        long now = System.currentTimeMillis();
        dbProps.put(LAST_GROUPINFO_PURGE + subnet.getSubnetId(), new Long(now).toString());
        this.dbMgr.saveAppProperties(appProps);
        return deleted;
    }
}

