/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import com.intel.stl.api.Utils;
import com.intel.stl.api.subnet.CableInfoBean;
import com.intel.stl.api.subnet.DDCableInfoBean;
import com.intel.stl.fecdriver.messages.adapter.sa.CableInfoDD;
import com.intel.stl.fecdriver.messages.adapter.sa.CableInfoStd;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CableRecordBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int lid;
    private short port;
    private byte length;
    private short address;
    private byte portType;
    private byte[] data;
    private List<CableRecordBean> otherBeans;
    private Byte cableType;
    private int totalLength;
    private CableInfoBean cableInfo;
    private DDCableInfoBean ddCableInfo;

    public CableRecordBean() {
    }

    public CableRecordBean(int lid, byte port, byte length, short address, byte portType, byte[] data) {
        this.lid = lid;
        this.port = Utils.unsignedByte(port);
        this.length = length;
        this.address = address;
        this.portType = portType;
        this.data = data;
        if (address == 128) {
            this.cableType = data[0];
        }
    }

    public int getLid() {
        return this.lid;
    }

    public void setLid(int lid) {
        this.lid = lid;
    }

    public short getPort() {
        return this.port;
    }

    public byte getLength() {
        return this.length;
    }

    public short getAddress() {
        return this.address;
    }

    public byte getPortType() {
        return this.portType;
    }

    public CableInfoBean getCableInfo() {
        return this.cableInfo;
    }

    public DDCableInfoBean getDdCableInfo() {
        return this.ddCableInfo;
    }

    public void setPort(short port) {
        this.port = port;
    }

    public void setPort(byte port) {
        this.port = Utils.unsignedByte(port);
    }

    public void setLength(byte length) {
        this.length = length;
    }

    public void setAddress(short address) {
        this.address = address;
    }

    public void setPortType(byte portType) {
        this.portType = portType;
    }

    public void setCableInfo(CableInfoBean cableInfo) {
        this.cableInfo = cableInfo;
    }

    public void setDdCableInfo(DDCableInfoBean ddCableInfo) {
        this.ddCableInfo = ddCableInfo;
    }

    public void combine(CableRecordBean bean) {
        if (this.cableInfo != null || this.ddCableInfo != null) {
            throw new IllegalArgumentException("Already combined data!");
        }
        if (this.otherBeans == null) {
            this.otherBeans = new ArrayList<CableRecordBean>();
            this.totalLength = this.length + 1;
        }
        this.otherBeans.add(bean);
        this.totalLength += bean.getLength() + 1;
        if (this.cableType == null && bean.cableType != null) {
            this.cableType = bean.cableType;
        }
        if (this.cableType == 24 && this.otherBeans.size() == 1) {
            byte[] tmpData = this.populateData();
            CableInfoDD cid = new CableInfoDD();
            cid.wrap(tmpData, 0);
            this.ddCableInfo = cid.toObject();
            this.otherBeans = null;
            this.data = null;
        } else if (this.cableType != null && this.otherBeans.size() == 1) {
            byte[] tmpData = this.populateData();
            CableInfoStd cis = new CableInfoStd();
            cis.wrap(tmpData, 0);
            this.cableInfo = cis.toObject();
            this.otherBeans = null;
            this.data = null;
        }
    }

    private byte[] populateData() {
        byte[] res = new byte[this.totalLength];
        System.arraycopy(this.data, 0, res, this.address - 128, this.length + 1);
        for (CableRecordBean bean : this.otherBeans) {
            System.arraycopy(bean.data, 0, res, bean.address - 128, bean.length + 1);
        }
        return res;
    }

    public String toString() {
        return "CableRecordBean [lid=" + this.lid + ", port=" + this.port + ", length=" + this.length + ",  address=" + this.address + ",  portType=" + this.portType + ", cableInfo=" + this.cableInfo + ", ddCableInfo=" + this.ddCableInfo + "]";
    }
}

