/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import java.util.HashMap;
import java.util.Map;

public enum DefaultDeviceGroup {
    ALL(0, "All"),
    HFI(1, "HFIs"),
    SW(2, "SWs"),
    TFI(3, "TFIs");

    private final String name;
    private final int id;
    private static final Map<String, DefaultDeviceGroup> map;

    private DefaultDeviceGroup(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DefaultDeviceGroup getType(String name) {
        return map.get(name);
    }

    public int getId() {
        return this.id;
    }

    static {
        map = new HashMap<String, DefaultDeviceGroup>(){
            private static final long serialVersionUID = -2334542879744460474L;
            {
                for (DefaultDeviceGroup type : DefaultDeviceGroup.values()) {
                    this.put(type.name, type);
                }
            }
        };
    }
}

