/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import com.intel.stl.api.Utils;
import com.intel.stl.api.subnet.NodeType;
import java.io.Serializable;

public class NodeInfoBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte baseVersion;
    private byte classVersion;
    private NodeType nodeType;
    private short numPorts;
    private long sysImageGUID;
    private long nodeGUID;
    private long portGUID;
    private int partitionCap;
    private short deviceID;
    private int revision;
    private short localPortNum;
    private int vendorID;

    public NodeInfoBean() {
    }

    public NodeInfoBean(byte baseVersion, byte classVersion, byte nodeType, byte numPorts, long sysImageGUID, long nodeGUID, long portGUID, short partitionCap, short deviceID, int revision, byte localPortNum, int vendorID) {
        this.baseVersion = baseVersion;
        this.classVersion = classVersion;
        this.nodeType = NodeType.getNodeType(nodeType);
        this.numPorts = Utils.unsignedByte(numPorts);
        this.sysImageGUID = sysImageGUID;
        this.nodeGUID = nodeGUID;
        this.portGUID = portGUID;
        this.partitionCap = Utils.unsignedShort(partitionCap);
        this.deviceID = deviceID;
        this.revision = revision;
        this.localPortNum = Utils.unsignedByte(localPortNum);
        this.vendorID = vendorID;
    }

    public byte getBaseVersion() {
        return this.baseVersion;
    }

    public void setBaseVersion(byte baseVersion) {
        this.baseVersion = baseVersion;
    }

    public byte getClassVersion() {
        return this.classVersion;
    }

    public void setClassVersion(byte classVersion) {
        this.classVersion = classVersion;
    }

    public byte getNodeType() {
        return this.nodeType.getId();
    }

    public void setNodeType(byte nodeType) {
        this.nodeType = NodeType.getNodeType(nodeType);
    }

    public NodeType getNodeTypeEnum() {
        return this.nodeType;
    }

    public void setNodeTypeEnum(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public short getNumPorts() {
        return this.numPorts;
    }

    public void setNumPorts(short numPorts) {
        this.numPorts = numPorts;
    }

    public void setNumPorts(byte numPorts) {
        this.numPorts = Utils.unsignedByte(numPorts);
    }

    public long getSysImageGUID() {
        return this.sysImageGUID;
    }

    public void setSysImageGUID(long sysImageGUID) {
        this.sysImageGUID = sysImageGUID;
    }

    public long getNodeGUID() {
        return this.nodeGUID;
    }

    public void setNodeGUID(long nodeGUID) {
        this.nodeGUID = nodeGUID;
    }

    public long getPortGUID() {
        return this.portGUID;
    }

    public void setPortGUID(long portGUID) {
        this.portGUID = portGUID;
    }

    public int getPartitionCap() {
        return this.partitionCap;
    }

    public void setPartitionCap(int partitionCap) {
        this.partitionCap = partitionCap;
    }

    public void setPartitionCap(short partitionCap) {
        this.partitionCap = Utils.unsignedShort(partitionCap);
    }

    public short getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(short deviceID) {
        this.deviceID = deviceID;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public short getLocalPortNum() {
        return this.localPortNum;
    }

    public void setLocalPortNum(short localPortNum) {
        this.localPortNum = localPortNum;
    }

    public void setLocalPortNum(byte localPortNum) {
        this.localPortNum = Utils.unsignedByte(localPortNum);
    }

    public int getVendorID() {
        return this.vendorID;
    }

    public void setVendorID(int vendorID) {
        this.vendorID = vendorID;
    }

    public String toString() {
        return "NodeInfoBean [baseVersion=" + this.baseVersion + ", classVersion=" + this.classVersion + ", nodeType=" + (this.nodeType == null ? "null" : Byte.valueOf(this.nodeType.getId())) + ", numPorts=" + this.numPorts + ", sysImageGUID=0x" + Long.toHexString(this.sysImageGUID) + ", nodeGUID=0x" + Long.toHexString(this.nodeGUID) + ", portGUID=0x" + Long.toHexString(this.portGUID) + ", partitionCap=" + this.partitionCap + ", deviceID=" + this.deviceID + ", revision=" + this.revision + ", localPortNum=" + this.localPortNum + ", vendorID=" + this.vendorID + "]";
    }
}

