/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OutputModuleType {
    NONE(0),
    SDR(1),
    DDR(2),
    QDR(4),
    FDR(8),
    EDR(16),
    UNKNOWN(-32);

    private final byte id;
    private static Logger log;

    private OutputModuleType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static OutputModuleType[] getOuputModuleType(byte id) {
        if (id == OutputModuleType.NONE.id) {
            return new OutputModuleType[]{NONE};
        }
        if ((id & OutputModuleType.UNKNOWN.id) == OutputModuleType.UNKNOWN.id) {
            return new OutputModuleType[]{UNKNOWN};
        }
        ArrayList<OutputModuleType> res = new ArrayList<OutputModuleType>();
        for (OutputModuleType omt : OutputModuleType.values()) {
            if ((id & omt.id) != omt.id) continue;
            res.add(omt);
        }
        if (res.isEmpty()) {
            log.error("Unknown OutputModuleType : id ='" + id + "'");
            return new OutputModuleType[]{UNKNOWN};
        }
        return res.toArray(new OutputModuleType[0]);
    }

    static {
        log = LoggerFactory.getLogger(OutputModuleType.class);
    }
}

