/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetException;
import com.intel.stl.api.subnet.impl.LinkCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.BaseCache;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DBLinkCacheImpl
extends BaseCache
implements LinkCache {
    private final DatabaseManager dbMgr;
    private final SAHelper helper;

    public DBLinkCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.dbMgr = cacheMgr.getDatabaseManager();
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<LinkRecordBean> getLinks(boolean includeInactive) throws SubnetDataNotFoundException {
        ArrayList<LinkRecordBean> res = new ArrayList<LinkRecordBean>();
        try {
            List<LinkRecordBean> links = this.dbMgr.getLinks(this.getSubnetName());
            if (links != null && !links.isEmpty()) {
                for (LinkRecordBean link : links) {
                    if (!includeInactive && !link.isActive()) continue;
                    res.add(link);
                }
            }
        }
        catch (DatabaseException e) {
            SubnetException se = SubnetApi.getSubnetException(e);
            log.error("Error getting links", (Throwable)e);
            throw se;
        }
        if (!res.isEmpty()) {
            return Collections.unmodifiableList(res);
        }
        throw new SubnetDataNotFoundException(STLMessages.STL30058_LINK_NOT_FOUND_CACHE_ALL);
    }

    @Override
    public LinkRecordBean getLinkBySource(int lid, short portNum) throws SubnetDataNotFoundException {
        SubnetDataNotFoundException le = null;
        try {
            return this.dbMgr.getLinkBySource(this.getSubnetName(), lid, portNum);
        }
        catch (DatabaseException e) {
            SubnetException se = SubnetApi.getSubnetException(e);
            log.error("Error getting link by source lid=" + lid + ", portNum=" + portNum, (Throwable)e);
            throw se;
        }
        catch (SubnetDataNotFoundException e) {
            le = e;
            log.info("Couldn't find Link by source Lid=" + lid + ", portNum=" + portNum + "  from cache");
            List<LinkRecordBean> links = null;
            try {
                links = this.helper.getLinks(lid);
            }
            catch (Exception exception) {
                SubnetException se = SubnetApi.getSubnetException(exception);
                log.error("Error getting link by source lid=" + lid + ", portNum=" + portNum + " from Fabric", (Throwable)exception);
                throw se;
            }
            if (links != null && !links.isEmpty()) {
                for (LinkRecordBean link : links) {
                    if (link.getFromPortIndex() != portNum) continue;
                    this.cacheMgr.startTopologyUpdateTask();
                    return link;
                }
            }
            throw le;
        }
    }

    @Override
    public LinkRecordBean getLinkByDestination(int lid, short portNum) throws SubnetDataNotFoundException {
        SubnetDataNotFoundException le = null;
        try {
            return this.dbMgr.getLinkByDestination(this.getSubnetName(), lid, portNum);
        }
        catch (DatabaseException e) {
            SubnetException se = SubnetApi.getSubnetException(e);
            log.error("Error getting link by destination lid=" + lid + ", portNum=" + portNum, (Throwable)e);
            throw se;
        }
        catch (SubnetDataNotFoundException e) {
            le = e;
            log.info("Couldn't find Link by destination Lid=" + lid + ", portNum=" + portNum + "  from cache");
            List<LinkRecordBean> links = null;
            try {
                links = this.helper.getLinks(lid);
            }
            catch (Exception exception) {
                SubnetException se = SubnetApi.getSubnetException(exception);
                log.error("Error getting links for lid " + lid, (Throwable)exception);
                throw se;
            }
            if (links != null && !links.isEmpty()) {
                for (LinkRecordBean link : links) {
                    if (link.getFromPortIndex() != portNum) continue;
                    this.cacheMgr.startTopologyUpdateTask();
                    return new LinkRecordBean(link.getToLID(), link.getToPortIndex(), link.getFromLID(), link.getFromPortIndex());
                }
            }
            throw le;
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean refreshCache() {
        return true;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        return true;
    }

    private String getSubnetName() {
        return this.helper.getSubnetDescription().getName();
    }
}

