/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.NodeState;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.impl.NodeCache;
import com.intel.stl.api.subnet.impl.PortCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.common.STLMessages;
import com.intel.stl.common.SimpleCache;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class PortCacheImpl
extends MemoryCache<SimpleCache<Integer, PortArray>>
implements PortCache {
    private final SimpleCache<Integer, NodeState> portsStates;
    private final SimpleCache<Integer, PortArray> portsCache;
    private final AtomicReference<EnumMap<NodeType, Long>> portsTypeDist = new AtomicReference<Object>(null);
    private final AtomicReference<Long> subnetPrefix = new AtomicReference<Object>(null);
    private final SAHelper helper;

    public PortCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
        this.portsCache = this.createPortsCache();
        this.portsStates = this.createPortsStatesCache();
    }

    protected SimpleCache<Integer, PortArray> createPortsCache() {
        return new SimpleCache<Integer, PortArray>(100, this.getTickResolution());
    }

    protected SimpleCache<Integer, NodeState> createPortsStatesCache() {
        return new SimpleCache<Integer, NodeState>(5000, 600000L);
    }

    @Override
    public List<PortRecordBean> getPorts() throws SubnetDataNotFoundException {
        try {
            List<PortRecordBean> ports = this.helper.getPorts();
            this.refresh(ports);
            if (ports != null) {
                return ports;
            }
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
        throw new SubnetDataNotFoundException(STLMessages.STL30062_PORT_NOT_FOUND_CACHE_ALL);
    }

    @Override
    public PortRecordBean getPortByPortNum(int lid, short portNum) throws SubnetDataNotFoundException {
        PortArray portArray = this.portsCache.get(lid);
        if (portArray != null) {
            PortRecordBean res = portArray.getPort(portNum);
            if (res != null) {
                return res;
            }
        } else {
            try {
                List<PortRecordBean> ports = this.helper.getPorts(lid);
                if (ports != null && !ports.isEmpty()) {
                    short maxPort = 0;
                    PortRecordBean res = null;
                    for (PortRecordBean port : ports) {
                        if (port.getPortNum() == portNum) {
                            res = port;
                        }
                        if (port.getPortNum() <= maxPort) continue;
                        maxPort = port.getPortNum();
                    }
                    this.portsCache.push(lid, new PortArray(ports, maxPort));
                    if (res != null) {
                        return res;
                    }
                }
            }
            catch (Exception e) {
                throw SubnetApi.getSubnetException(e);
            }
        }
        throw new SubnetDataNotFoundException((IMessage)STLMessages.STL30063_PORT_NOT_FOUND_CACHE, StringUtils.intHexString(lid), portNum);
    }

    @Override
    public PortRecordBean getPortByLocalPortNum(int lid, short localPortNum) throws SubnetDataNotFoundException {
        PortArray portArray = this.portsCache.get(lid);
        if (portArray != null) {
            PortRecordBean res = portArray.getPortByLocalPortNum(localPortNum);
            if (res != null) {
                return res;
            }
        } else {
            try {
                List<PortRecordBean> ports = this.helper.getPorts(lid);
                if (ports != null && !ports.isEmpty()) {
                    short maxPort = 0;
                    PortRecordBean res = null;
                    for (PortRecordBean port : ports) {
                        if (port.getPortInfo().getLocalPortNum() == localPortNum) {
                            res = port;
                        }
                        if (port.getPortNum() <= maxPort) continue;
                        maxPort = port.getPortNum();
                    }
                    this.portsCache.push(lid, new PortArray(ports, maxPort));
                    if (res != null) {
                        return res;
                    }
                }
            }
            catch (Exception e) {
                throw SubnetApi.getSubnetException(e);
            }
        }
        throw new SubnetDataNotFoundException((IMessage)STLMessages.STL30064_PORT_NOT_FOUND_CACHE_LOCAL, lid, localPortNum);
    }

    @Override
    public boolean hasPort(int lid, short portNum) {
        boolean res = false;
        NodeState nodeState = this.portsStates.get(lid);
        if (nodeState != null) {
            res = nodeState.isActivePort(portNum);
        } else {
            try {
                NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
                NodeRecordBean node = nodeCache.getNode(lid);
                List<PortRecordBean> ports = this.helper.getPorts(lid);
                if (ports != null && !ports.isEmpty()) {
                    nodeState = new NodeState(node.getNodeType(), node.getNodeInfo().getNumPorts());
                    this.portsStates.push(lid, nodeState);
                    for (PortRecordBean port : ports) {
                        nodeState.setActivePort(port.getPortNum());
                        if (port.getPortNum() != portNum) continue;
                        res = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    @Override
    public boolean hasLocalPort(int lid, short localPortNum) {
        boolean res = false;
        NodeState nodeState = this.portsStates.get(lid);
        if (nodeState != null) {
            res = nodeState.isActivePort(localPortNum);
        } else {
            try {
                NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
                NodeRecordBean node = nodeCache.getNode(lid);
                List<PortRecordBean> ports = this.helper.getPorts(lid);
                if (ports != null && !ports.isEmpty()) {
                    nodeState = new NodeState(node.getNodeType(), node.getNodeInfo().getNumPorts());
                    this.portsStates.push(lid, nodeState);
                    for (PortRecordBean port : ports) {
                        short lpc = port.getPortInfo().getLocalPortNum();
                        nodeState.setActivePort(lpc);
                        if (lpc != localPortNum) continue;
                        res = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    @Override
    public EnumMap<NodeType, Long> getPortsTypeDist(boolean countInternalMgrPort, boolean refresh) throws SubnetDataNotFoundException {
        if (refresh || this.portsTypeDist.get() == null) {
            List<PortRecordBean> ports = this.getPorts();
            this.refresh(ports);
        }
        return this.portsTypeDist.get();
    }

    protected synchronized void refresh(List<PortRecordBean> ports) throws SubnetDataNotFoundException {
        if (ports == null) {
            this.portsStates.clear();
            this.portsTypeDist.set(null);
            return;
        }
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        EnumMap<NodeType, Long> portsTypeDistMap = new EnumMap<NodeType, Long>(NodeType.class);
        HashMap<Integer, NodeState> processed = new HashMap<Integer, NodeState>();
        long desiredTotalPorts = 0L;
        long realTotalPorts = 0L;
        for (PortRecordBean port : ports) {
            Long count;
            NodeType type;
            int lid = port.getEndPortLID();
            NodeState state = (NodeState)processed.get(lid);
            if (state == null) {
                NodeRecordBean node = nodeCache.getNode(lid);
                NodeType type2 = node.getNodeType();
                state = new NodeState(type2, node.getNodeInfo().getNumPorts());
                processed.put(lid, state);
                this.portsStates.push(lid, state);
                switch (type2) {
                    case SWITCH: {
                        desiredTotalPorts += (long)(node.getNodeInfo().getNumPorts() + 1);
                        break;
                    }
                    case HFI: {
                        ++desiredTotalPorts;
                        break;
                    }
                }
            }
            portsTypeDistMap.put(type, (count = (Long)portsTypeDistMap.get((Object)(type = state.getType()))) == null ? 1L : count + 1L);
            ++realTotalPorts;
            if (type == NodeType.HFI) {
                state.setActivePort(port.getPortInfo().getLocalPortNum());
                continue;
            }
            state.setActivePort(port.getPortNum());
        }
        portsTypeDistMap.put(NodeType.OTHER, desiredTotalPorts - realTotalPorts);
        this.portsTypeDist.set(portsTypeDistMap);
    }

    @Override
    public long getSubnetPrefix() {
        if (this.subnetPrefix.get() == null) {
            try {
                List<PortRecordBean> ports = this.getPorts();
                if (ports.isEmpty()) {
                    return 0L;
                }
                long prefix = ports.get(0).getPortInfo().getSubnetPrefix();
                this.subnetPrefix.set(new Long(prefix));
            }
            catch (SubnetDataNotFoundException e) {
                return 0L;
            }
        }
        return this.subnetPrefix.get();
    }

    @Override
    protected SimpleCache<Integer, PortArray> retrieveObjectForCache() throws Exception {
        return this.portsCache;
    }

    @Override
    public void reset() {
        super.reset();
        this.portsStates.clear();
        this.portsCache.clear();
        this.portsTypeDist.set(null);
        this.subnetPrefix.set(null);
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        this.portsStates.remove(notice.getLid());
        this.portsCache.remove(notice.getLid());
        this.portsTypeDist.set(null);
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }

    protected class PortArray {
        private final PortRecordBean[] ports;

        public PortArray(List<PortRecordBean> beans, Short maxPort) {
            this.ports = new PortRecordBean[maxPort + 1];
            Iterator<PortRecordBean> iterator = beans.iterator();
            while (iterator.hasNext()) {
                PortRecordBean bean;
                this.ports[bean.getPortNum()] = bean = iterator.next();
            }
        }

        public PortRecordBean getPort(short portNum) {
            if (portNum < this.ports.length) {
                return this.ports[portNum];
            }
            return null;
        }

        public PortRecordBean getPortByLocalPortNum(short localPortNum) {
            for (PortRecordBean port : this.ports) {
                if (port == null || port.getPortInfo().getLocalPortNum() != localPortNum) continue;
                return port;
            }
            return null;
        }

        public PortRecordBean[] getPorts() {
            return this.ports;
        }
    }
}

