/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.SC2SLMTRecordBean;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SC2SLMTCache;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SC2SLMTCacheImpl
extends MemoryCache<Map<Integer, SC2SLMTRecordBean>>
implements SC2SLMTCache {
    private final SAHelper helper;

    public SC2SLMTCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<SC2SLMTRecordBean> getSC2SLMTs() {
        Map map = (Map)this.getCachedObject();
        List<SC2SLMTRecordBean> res = new ArrayList<SC2SLMTRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (SC2SLMTRecordBean sc2sl : map.values()) {
                res.add(sc2sl);
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getSC2SLMTs();
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public SC2SLMTRecordBean getSC2SLMT(int lid) {
        Map map = (Map)this.getCachedObject();
        if (map != null) {
            return (SC2SLMTRecordBean)map.get(lid);
        }
        try {
            SC2SLMTRecordBean res = this.helper.getSC2SLMT(lid);
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            log.error("Error getting Cable Infos by lid " + lid, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    protected Map<Integer, SC2SLMTRecordBean> retrieveObjectForCache() throws Exception {
        List<SC2SLMTRecordBean> sc2sls = this.helper.getSC2SLMTs();
        log.info("Retrieve " + (sc2sls == null ? 0 : sc2sls.size()) + " SC2SLMT Infos from FE");
        HashMap<Integer, SC2SLMTRecordBean> map = null;
        if (sc2sls != null) {
            map = new HashMap<Integer, SC2SLMTRecordBean>();
            for (SC2SLMTRecordBean sc2sl : sc2sls) {
                map.put(sc2sl.getLid(), sc2sl);
            }
        }
        return map;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map map = (Map)this.getCachedObject();
        if (map != null && !map.isEmpty()) {
            map.remove(notice.getLid());
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

