/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyUpdateTask
extends AsyncTask<Void> {
    private static Logger log = LoggerFactory.getLogger(TopologyUpdateTask.class);
    private final DatabaseManager dbMgr;
    private final SAHelper helper;

    public TopologyUpdateTask(SAHelper helper, DatabaseManager dbMgr) {
        this.helper = helper;
        this.dbMgr = dbMgr;
    }

    @Override
    public Void process() throws Exception {
        SubnetDescription subnet = this.helper.getSubnetDescription();
        String subnetName = subnet.getName();
        log.info("Updating topology in the background for subnet: " + subnetName);
        List<NodeRecordBean> allNodes = this.helper.getNodes();
        List<LinkRecordBean> allLinks = this.helper.getLinks();
        if (allNodes == null || allLinks == null) {
            log.error("Subnet manager for subnet " + subnetName + " returned no nodes or no links");
        } else {
            this.dbMgr.saveTopology(subnet.getName(), allNodes, allLinks);
            log.info("Topology has been updated");
        }
        return null;
    }
}

