/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.common;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SimpleCache<K, V> {
    private static final String NAME = "cache_cleanup_thread-";
    private static int THREAD_COUNT = 0;
    private static final int DEFAULT_CAPACITY = 1000;
    private static final long DEFAULT_LEFTTME = 5000L;
    private int capacity;
    private final long lifeTimeMs;
    private final Map<K, Reference<ValueItem>> cache = new HashMap<K, Reference<ValueItem>>();
    private final LinkedList<KeyItem> keyItems = new LinkedList();
    private long lastCheckTime;
    private long checkInterval;
    private CleanupTask cleanupTask;
    protected Comparator<KeyItem> keyCountComp = new Comparator<KeyItem>(){

        @Override
        public int compare(KeyItem o1, KeyItem o2) {
            int c2;
            int c1 = o1.getCount();
            return c1 > (c2 = o2.getCount()) ? 1 : (c1 < c2 ? -1 : 0);
        }
    };

    public SimpleCache() {
        this(1000, 5000L);
    }

    public SimpleCache(int capacity) {
        this(capacity, 5000L);
    }

    public SimpleCache(int capacity, long lifeTimeMs) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = capacity;
        this.lifeTimeMs = lifeTimeMs;
        this.checkInterval = lifeTimeMs / 4L + 100L;
        this.cleanupTask = new CleanupTask();
    }

    public synchronized void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = capacity;
        this.trim();
    }

    public synchronized void push(K key, V value) {
        ValueItem vi;
        Reference<ValueItem> ref = this.cache.get(key);
        ValueItem valueItem = vi = ref == null ? null : ref.get();
        if (vi == null) {
            KeyItem ki = new KeyItem(key);
            vi = new ValueItem(ki, value);
            ref = this.createReference(vi);
            this.cache.put(key, ref);
            this.keyItems.remove(ki);
            this.keyItems.add(ki);
        } else {
            vi.setValue(value);
            vi.getKeyItem().accessed();
        }
        this.trim();
        this.scheduleCleanup();
    }

    protected Reference<ValueItem> createReference(ValueItem vi) {
        return new SoftReference<ValueItem>(vi);
    }

    public synchronized V get(K key) {
        V res = null;
        Reference<ValueItem> ref = this.cache.get(key);
        if (ref != null) {
            ValueItem vi = ref.get();
            if (vi == null) {
                this.remove(key);
            } else {
                vi.getKeyItem().accessed();
                res = vi.getValue();
            }
        }
        this.scheduleCleanup();
        return res;
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized void clear() {
        this.cache.clear();
        this.keyItems.clear();
    }

    public synchronized void remove(K key) {
        ValueItem vi;
        Reference<ValueItem> ref = this.cache.remove(key);
        ValueItem valueItem = vi = ref == null ? null : ref.get();
        if (vi != null) {
            this.keyItems.remove(vi.getKeyItem());
        } else {
            this.keyItems.remove(new KeyItem(key));
        }
    }

    protected void trim() {
        if (this.keyItems.size() > this.capacity) {
            this.cleanup();
            if (this.keyItems.size() > this.capacity) {
                Collections.sort(this.keyItems, this.keyCountComp);
                while (this.keyItems.size() > this.capacity) {
                    KeyItem item = this.keyItems.remove();
                    this.cache.remove(item.getKey());
                }
            }
        }
    }

    protected void scheduleCleanup() {
        this.lastCheckTime = System.currentTimeMillis();
        if (!this.cleanupTask.isRunning()) {
            this.cleanupTask.isRunning = true;
            new Thread((Runnable)this.cleanupTask, NAME + ++THREAD_COUNT).start();
        }
    }

    protected synchronized void cleanup() {
        long time = System.currentTimeMillis();
        for (int i = this.keyItems.size() - 1; i >= 0; --i) {
            KeyItem item = this.keyItems.get(i);
            Object key = item.getKey();
            Reference<ValueItem> ref = this.cache.get(key);
            if (item.alive(time, this.lifeTimeMs) && ref != null && ref.get() != null) continue;
            this.cache.remove(key);
            this.keyItems.remove(i);
        }
    }

    protected class CleanupTask
    implements Runnable {
        private boolean isRunning;

        protected CleanupTask() {
        }

        @Override
        public void run() {
            try {
                while (System.currentTimeMillis() - SimpleCache.this.lastCheckTime < SimpleCache.this.lifeTimeMs) {
                    Thread.sleep(SimpleCache.this.checkInterval);
                }
                SimpleCache.this.cleanup();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.isRunning = false;
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    protected class ValueItem {
        private final KeyItem keyItem;
        private V value;

        public ValueItem(KeyItem keyItem, V value) {
            this.keyItem = keyItem;
            this.value = value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public KeyItem getKeyItem() {
            return this.keyItem;
        }

        public V getValue() {
            return this.value;
        }
    }

    protected class KeyItem {
        private int count;
        private long lastAccess;
        private final K key;

        public KeyItem(K key) {
            this.key = key;
            this.accessed();
        }

        public void accessed() {
            ++this.count;
            this.lastAccess = System.currentTimeMillis();
        }

        public int getCount() {
            return this.count;
        }

        public K getKey() {
            return this.key;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public boolean alive(long lifeTime) {
            return this.alive(System.currentTimeMillis(), lifeTime);
        }

        public boolean alive(long currentTime, long lifeTime) {
            return currentTime - this.lastAccess < lifeTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyItem other = (KeyItem)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        private SimpleCache getOuterType() {
            return SimpleCache.this;
        }

        public String toString() {
            return "KeyItem [key=" + this.key + ", count=" + this.count + ", lastAccess=" + this.lastAccess + "]";
        }
    }
}

