/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.common;

import com.intel.stl.api.Utils;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSession {
    private static Logger log = LoggerFactory.getLogger(SshSession.class);
    private String host;
    private int port;
    private String userName;
    private Session session = null;
    private String charsetName = "ASCII";
    private int exitStatus;
    private final ExecutorService readingThread;
    private JSch jsch;

    public SshSession() throws JSchException {
        this.jsch = this.createJSch();
        this.readingThread = Executors.newSingleThreadExecutor(new SshSessionThreadFactory());
    }

    public void connect(String host, int port, String user, char[] password) throws JSchException {
        this.disconnect();
        this.host = host;
        this.port = port;
        this.userName = user;
        this.session = this.jsch.getSession(user, host, port);
        this.session.setUserInfo((UserInfo)new MyUserInfo(password));
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
        this.session.setConfig(config);
        this.session.connect();
    }

    public SshSession(Session session) {
        this.session = session;
        this.readingThread = Executors.newSingleThreadExecutor(new SshSessionThreadFactory());
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public List<String> exec(String command) throws Exception {
        return this.executeCommand(command, null);
    }

    public List<String> exec(String command, long timeout) throws Exception {
        return this.executeCommand(command, new Long(timeout));
    }

    public Future<List<String>> submit(String command) throws IOException, JSchException {
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        channel.setCommand(command);
        channel.setPty(true);
        SshOutputLineReader reader = new SshOutputLineReader(channel);
        Future<List<String>> future = this.readingThread.submit(reader);
        channel.connect();
        return future;
    }

    public int getLastExitStatus() {
        return this.exitStatus;
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    protected List<String> executeCommand(String command, Long timeout) throws Exception {
        List<String> response;
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        channel.setCommand(command);
        channel.setPty(true);
        SshOutputLineReader reader = new SshOutputLineReader(channel);
        Future<List<String>> future = this.readingThread.submit(reader);
        channel.connect();
        try {
            response = timeout == null ? future.get() : future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (InterruptedException e) {
            log.warn("SSH session command execution interrupted after reading {} lines.", (Object)reader.getLinesRead());
            future.cancel(true);
            response = reader.getPartialResults();
        }
        catch (ExecutionException e) {
            Exception cause = (Exception)e.getCause();
            log.error("SSH session command execution had an error: {}", (Object)cause.getMessage(), (Object)cause);
            throw cause;
        }
        finally {
            this.exitStatus = channel.getExitStatus();
            reader.close();
            channel.disconnect();
        }
        return response;
    }

    protected JSch createJSch() throws JSchException {
        return Utils.createJSch();
    }

    private class MyUserInfo
    implements UserInfo {
        private final String password;

        public MyUserInfo(char[] password) {
            this.password = new String(password);
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptYesNo(String str) {
            System.out.println(str);
            return true;
        }

        public void showMessage(String message) {
            System.out.println("showMessage: " + message);
        }
    }

    private class SshSessionThreadFactory
    implements ThreadFactory {
        private static final String SSHSESSION_THREAD_PREFIX = "sshread-thread-";
        private final AtomicInteger threadCount = new AtomicInteger(1);

        private SshSessionThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = SSHSESSION_THREAD_PREFIX + this.threadCount.getAndIncrement();
            return new Thread(r, threadName);
        }
    }

    private class SshOutputLineReader
    implements Callable<List<String>> {
        private int lineCt;
        private final PipedInputStream snk;
        private final PipedOutputStream src;
        private final BufferedReader br;
        private final InputStream in;
        private final List<String> read;
        private final ChannelExec channel;

        public SshOutputLineReader(ChannelExec channel) throws IOException {
            this.channel = channel;
            this.in = channel.getInputStream();
            this.read = new ArrayList<String>();
            this.snk = new PipedInputStream();
            this.src = new PipedOutputStream(this.snk);
            channel.setOutputStream((OutputStream)this.src);
            channel.setErrStream((OutputStream)this.src);
            InputStreamReader reader = new InputStreamReader((InputStream)this.snk, SshSession.this.charsetName);
            this.br = new BufferedReader(reader);
        }

        @Override
        public List<String> call() throws Exception {
            String line;
            while (this.in.available() > 0 || !this.channel.isClosed()) {
                line = this.br.readLine();
                if (line == null) continue;
                this.read.add(line);
                ++this.lineCt;
            }
            while (this.br.ready()) {
                line = this.br.readLine();
                this.read.add(line);
                ++this.lineCt;
            }
            return this.read;
        }

        public int getLinesRead() {
            return this.lineCt;
        }

        public List<String> getPartialResults() {
            return this.read;
        }

        public void close() {
            try {
                try {
                    this.src.close();
                }
                finally {
                    this.br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

