/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.api.StringUtils;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.BaseProcessingService;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AsyncTask<T>
implements Callable<T> {
    protected static Logger log = LoggerFactory.getLogger(AsyncTask.class);
    private BaseProcessingService.AsyncFutureTask<T> future;
    private Map<String, String> loggingContextMap;

    @Override
    public T call() throws Exception {
        if (this.loggingContextMap != null) {
            MDC.setContextMap(this.loggingContextMap);
        }
        try {
            T result = this.process();
            return result;
        }
        catch (RejectedExecutionException re) {
            log.info(STLMessages.STL60005_EXCEPTION_EXECUTING_TASK.getDescription(this.getClass().getSimpleName(), StringUtils.getErrorMessage(re)), (Throwable)re);
            log.info(STLMessages.STL60007_SUBMITTERS_TRACE.getDescription(), (Throwable)this.future.getClientTrace());
            throw re;
        }
        catch (Exception e) {
            log.error(STLMessages.STL60005_EXCEPTION_EXECUTING_TASK.getDescription(this.getClass().getSimpleName(), StringUtils.getErrorMessage(e)), (Throwable)e);
            log.error(STLMessages.STL60007_SUBMITTERS_TRACE.getDescription(), (Throwable)this.future.getClientTrace());
            throw e;
        }
    }

    public FutureTask<T> getFuture() {
        return this.future;
    }

    protected void setFuture(BaseProcessingService.AsyncFutureTask<T> future) {
        this.future = future;
    }

    protected void setLoggingContextMap(Map<String, String> loggingContextMap) {
        this.loggingContextMap = loggingContextMap;
    }

    public void checkArguments(Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) continue;
            IllegalArgumentException iae = new IllegalArgumentException(STLMessages.STL60004_ARGUMENT_CANNOT_BE_NULL.getDescription(i + 1, arguments[i].getClass().getCanonicalName()));
            throw iae;
        }
    }

    public abstract T process() throws Exception;
}

