/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.ManagedCache;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCache
implements ManagedCache {
    protected static Logger log = LoggerFactory.getLogger(CacheManager.class);
    protected final AtomicBoolean cacheReady = new AtomicBoolean(false);
    protected CacheManager cacheMgr;

    public BaseCache(CacheManager cacheMgr) {
        this.cacheMgr = cacheMgr;
    }

    @Override
    public boolean isCacheReady() {
        return this.cacheReady.get();
    }

    @Override
    public void setCacheReady(boolean ready) {
        this.cacheReady.set(ready);
    }

    @Override
    public synchronized void updateCache() {
        if (!this.cacheReady.get()) {
            boolean success = this.refreshCache();
            this.cacheReady.set(success);
        }
    }

    @Override
    public synchronized void processNotice(NoticeProcess notice) throws Exception {
        if (!this.cacheReady.get()) {
            return;
        }
        boolean cacheStatus = this.cacheReady.get();
        this.cacheReady.set(false);
        try {
            boolean success = this.refreshCache(notice);
            if (!success) {
                log.error("Error processing notice in cache " + this.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            log.error("Exception processing notice in cache " + this.getClass().getSimpleName(), (Throwable)e);
            throw e;
        }
        finally {
            this.cacheReady.set(cacheStatus);
        }
    }

    public abstract boolean refreshCache();

    public abstract boolean refreshCache(NoticeProcess var1) throws Exception;
}

