/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.api.performance.impl.GroupCacheImpl;
import com.intel.stl.api.performance.impl.GroupConfCacheImpl;
import com.intel.stl.api.performance.impl.PMConfigCacheImpl;
import com.intel.stl.api.subnet.impl.CableCacheImpl;
import com.intel.stl.api.subnet.impl.LFTCacheImpl;
import com.intel.stl.api.subnet.impl.LinkCacheImpl;
import com.intel.stl.api.subnet.impl.MFTCacheImpl;
import com.intel.stl.api.subnet.impl.NodeCacheImpl;
import com.intel.stl.api.subnet.impl.PKeyTableCacheImpl;
import com.intel.stl.api.subnet.impl.PortCacheImpl;
import com.intel.stl.api.subnet.impl.SC2SLMTCacheImpl;
import com.intel.stl.api.subnet.impl.SC2VLNTMTCacheImpl;
import com.intel.stl.api.subnet.impl.SC2VLTMTCacheImpl;
import com.intel.stl.api.subnet.impl.SMCacheImpl;
import com.intel.stl.api.subnet.impl.SwitchCacheImpl;
import com.intel.stl.api.subnet.impl.VLArbTableCacheImpl;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.ManagedCache;

public enum MemCacheType {
    NODE(NodeCacheImpl.class),
    LINK(LinkCacheImpl.class),
    PORT(PortCacheImpl.class),
    SWITCH(SwitchCacheImpl.class),
    LFT(LFTCacheImpl.class),
    MFT(MFTCacheImpl.class),
    CABLE(CableCacheImpl.class),
    PKEYTABLE(PKeyTableCacheImpl.class),
    VLARBTABLE(VLArbTableCacheImpl.class),
    SM(SMCacheImpl.class),
    GROUP(GroupCacheImpl.class),
    GROUP_CONF(GroupConfCacheImpl.class),
    PM_CONF(PMConfigCacheImpl.class),
    SC2SL(SC2SLMTCacheImpl.class),
    SC2VLT(SC2VLTMTCacheImpl.class),
    SC2VLNT(SC2VLNTMTCacheImpl.class);

    private final Class<? extends ManagedCache> implementingClass;

    private MemCacheType(Class<? extends ManagedCache> implementingClass) {
        this.implementingClass = implementingClass;
    }

    public String getImplementingClassName() {
        return this.implementingClass.getCanonicalName();
    }

    public ManagedCache getInstance(CacheManager cacheManager) throws Exception {
        ManagedCache cache = this.implementingClass.getConstructor(CacheManager.class).newInstance(cacheManager);
        return cache;
    }
}

