/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.UserNotFoundException;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.performance.GroupConfigRspBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.GroupListBean;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.PerformanceDataNotFoundException;
import com.intel.stl.api.performance.PortConfigBean;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.datamanager.NoticeStatus;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;

public interface DatabaseManager {
    public AppInfo getAppInfo();

    public void saveAppProperties(Map<String, Properties> var1);

    public List<SubnetDescription> getSubnets();

    public SubnetDescription getSubnet(String var1);

    public SubnetDescription getSubnet(long var1);

    public SubnetDescription defineSubnet(SubnetDescription var1);

    public void updateSubnet(SubnetDescription var1) throws SubnetDataNotFoundException;

    public void removeSubnet(long var1) throws SubnetDataNotFoundException;

    public void saveEventRules(List<EventRule> var1);

    public List<EventRule> getEventRules();

    public List<NodeRecordBean> getNodes(String var1) throws SubnetDataNotFoundException;

    public List<LinkRecordBean> getLinks(String var1) throws SubnetDataNotFoundException;

    public List<LinkRecordBean> getLinks(String var1, int var2) throws SubnetDataNotFoundException;

    public NodeRecordBean getNode(String var1, int var2) throws SubnetDataNotFoundException;

    public NodeRecordBean getNode(String var1, long var2) throws SubnetDataNotFoundException;

    public NodeRecordBean getNodeByPortGUID(String var1, long var2) throws SubnetDataNotFoundException;

    public void saveTopology(String var1, List<NodeRecordBean> var2, List<LinkRecordBean> var3) throws SubnetDataNotFoundException;

    public long getTopologyId(String var1) throws SubnetDataNotFoundException;

    public EnumMap<NodeType, Integer> getNodeTypeDist(String var1) throws SubnetDataNotFoundException;

    public LinkRecordBean getLinkBySource(String var1, int var2, short var3) throws SubnetDataNotFoundException;

    public LinkRecordBean getLinkByDestination(String var1, int var2, short var3) throws SubnetDataNotFoundException;

    public UserSettings getUserSettings(String var1, String var2) throws UserNotFoundException;

    public void saveUserSettings(String var1, UserSettings var2);

    public void saveGroupInfos(String var1, List<GroupInfoBean> var2);

    public void saveImageInfos(String var1, List<ImageInfoBean> var2);

    public int purgeGroupInfos(String var1, long var2);

    public void saveGroupConfig(String var1, String var2, List<PortConfigBean> var3);

    public void saveGroupList(String var1, List<GroupListBean> var2);

    public List<GroupInfoBean> getGroupInfo(String var1, String var2, long var3, long var5) throws PerformanceDataNotFoundException;

    public List<GroupConfigRspBean> getGroupConfig(String var1, String var2) throws PerformanceDataNotFoundException;

    public List<PortConfigBean> getPortConfig(String var1) throws PerformanceDataNotFoundException;

    public void saveNotices(String var1, NoticeBean[] var2);

    public Future<Boolean> processNotices(String var1, List<NoticeProcess> var2);

    public void resetNotices(String var1);

    public void updateNotice(String var1, long var2, NoticeStatus var4);

    public List<NoticeBean> getNotices(String var1, NoticeStatus var2);

    public List<NoticeBean> getNotices(String var1, NoticeStatus var2, NoticeStatus var3);
}

