/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.datamanager.DatabaseRecord;
import com.intel.stl.datamanager.NodeTypeRecord;
import com.intel.stl.datamanager.TopologyLinkRecord;
import com.intel.stl.datamanager.TopologyNodeRecord;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="NODES", indexes={@Index(name="IDX_NODE_PORTGUID", columnList="portGUID")})
public class NodeRecord
extends DatabaseRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private long nodeGUID;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeType", nullable=false, foreignKey=@ForeignKey(name="FK_NODE_NODETYPE"))
    private NodeTypeRecord type;
    private NodeRecordBean node;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="node")
    private Set<TopologyNodeRecord> topologies;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fromNode")
    private Set<TopologyLinkRecord> outboundLinks;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="toNode")
    private Set<TopologyLinkRecord> inboundLinks;

    public NodeRecord() {
    }

    public NodeRecord(NodeRecordBean node) {
        this.setNodeFields(node);
        this.node = node;
    }

    public long getNodeGUID() {
        return this.nodeGUID;
    }

    public void setNodeGUID(long nodeGUID) {
        this.nodeGUID = nodeGUID;
    }

    public NodeTypeRecord getType() {
        return this.type;
    }

    public void setType(NodeTypeRecord type) {
        this.type = type;
    }

    public NodeRecordBean getNode() {
        if (this.type == null) {
            throw new RuntimeException("NodeRecord for GUID " + this.nodeGUID + " has not been properly initialized (possibly a newly-created NodeRecord");
        }
        NodeInfoBean info = this.node.getNodeInfo();
        info.setNodeGUID(this.nodeGUID);
        info.setNodeTypeEnum(this.type.getNodeType());
        return this.node;
    }

    public void setNode(NodeRecordBean node) {
        this.setNodeFields(node);
        this.node = node;
    }

    public Set<TopologyNodeRecord> getTopologies() {
        return this.topologies;
    }

    public void setTopologies(Set<TopologyNodeRecord> topologies) {
        this.topologies = topologies;
    }

    public Set<TopologyLinkRecord> getOutboundLinks() {
        return this.outboundLinks;
    }

    public void setOutboundLinks(Set<TopologyLinkRecord> outboundLinks) {
        this.outboundLinks = outboundLinks;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.nodeGUID ^ this.nodeGUID >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeRecord other = (NodeRecord)obj;
        return this.nodeGUID == other.nodeGUID;
    }

    private void setNodeFields(NodeRecordBean node) {
        NodeInfoBean info = node.getNodeInfo();
        if (info == null) {
            throw new IllegalArgumentException("No NodeInfoBean attached to NodeRecordBean");
        }
        this.nodeGUID = info.getNodeGUID();
    }

    public String toString() {
        return "NodeRecord [nodeGUID=" + this.nodeGUID + ", node=" + this.getNode() + "]";
    }
}

