/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.notice.NoticeAttrBean;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.datamanager.NoticeId;
import com.intel.stl.datamanager.NoticeStatus;
import com.intel.stl.datamanager.SubnetRecord;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="noticeType", discriminatorType=DiscriminatorType.INTEGER)
@Table(name="NOTICES", indexes={@Index(name="IDX_NOTICE_STATUS", columnList="noticeStatus")})
public abstract class NoticeRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private NoticeId id = new NoticeId();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subnetId", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_NOTICE_SUBNET"))
    private SubnetRecord subnet;
    @Column(name="noticeType", insertable=false, updatable=false)
    private int noticeType;
    @Column(length=32)
    @Enumerated(value=EnumType.STRING)
    private NoticeStatus noticeStatus;
    @Embedded
    private NoticeBean notice;

    public NoticeRecord() {
    }

    public NoticeRecord(NoticeBean notice) {
        this.setNoticeFields(notice);
        this.notice = notice;
    }

    public NoticeId getId() {
        return this.id;
    }

    public void setId(NoticeId id) {
        this.id = id;
    }

    public SubnetRecord getSubnet() {
        return this.subnet;
    }

    public void setSubnet(SubnetRecord subnet) {
        this.id.setFabricId(subnet.getId());
        this.subnet = subnet;
    }

    public int getNoticeType() {
        return this.noticeType;
    }

    public void setNoticeType(int noticeType) {
        this.noticeType = noticeType;
    }

    public NoticeStatus getNoticeStatus() {
        return this.noticeStatus;
    }

    public void setNoticeStatus(NoticeStatus noticeStatus) {
        this.noticeStatus = noticeStatus;
    }

    public NoticeBean getNotice() {
        NoticeAttrBean attributes = this.getNoticeAttributes();
        this.notice.setAttributes(attributes);
        this.notice.setId(this.id.getNoticeId());
        return this.notice;
    }

    public void setNotice(NoticeBean notice) {
        this.setNoticeFields(notice);
        this.notice = notice;
    }

    public abstract NoticeAttrBean getNoticeAttributes();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NoticeRecord other = (NoticeRecord)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    private void setNoticeFields(NoticeBean notice) {
        NoticeAttrBean attributes = notice.getAttributes();
        if (attributes == null) {
            throw new IllegalArgumentException("No NoticeAttrBean attached to NoticeBean");
        }
        this.id.setNoticeId(notice.getId());
    }
}

