/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.datamanager.NodeRecord;
import com.intel.stl.datamanager.TopologyLinkId;
import com.intel.stl.datamanager.TopologyRecord;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="TOPOLOGIES_LINKS")
public class TopologyLinkRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TopologyLinkId id = new TopologyLinkId();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="topologyId", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_TOPOLOGYLINK_TOPOLOGY"))
    private TopologyRecord topology;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fromNodeGUID", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_TOPOLOGYLINK_FROMNODE"))
    private NodeRecord fromNode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="toNodeGUID", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_TOPOLOGYLINK_TONODE"))
    private NodeRecord toNode;
    private boolean active = true;
    private boolean fromPortActive = true;

    public TopologyLinkRecord() {
    }

    public TopologyLinkRecord(LinkRecordBean link) {
        this.id.setSourcePort(link.getFromPortIndex());
        this.id.setTargetPort(link.getToPortIndex());
    }

    public TopologyLinkId getId() {
        return this.id;
    }

    public void setId(TopologyLinkId id) {
        this.id = id;
    }

    public TopologyRecord getTopology() {
        return this.topology;
    }

    public void setTopology(TopologyRecord topology) {
        this.topology = topology;
        this.id.setLinkTopology(topology.getId());
    }

    public NodeRecord getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(NodeRecord fromNode) {
        this.fromNode = fromNode;
        this.id.setSourceNode(fromNode.getNodeGUID());
    }

    public short getFromPort() {
        return this.id.getSourcePort();
    }

    public void setFromPort(short fromPort) {
        this.id.setSourcePort(fromPort);
    }

    public NodeRecord getToNode() {
        return this.toNode;
    }

    public void setToNode(NodeRecord toNode) {
        this.toNode = toNode;
        this.id.setTargetNode(toNode.getNodeGUID());
    }

    public short getToPort() {
        return this.id.getTargetPort();
    }

    public void setToPort(short toPort) {
        this.id.setTargetPort(toPort);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isFromPortActive() {
        return this.fromPortActive;
    }

    public void setFromPortActive(boolean fromPortActive) {
        this.fromPortActive = fromPortActive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopologyLinkRecord other = (TopologyLinkRecord)obj;
        if (this.active != other.active) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "TopologyLinkRecord [id=" + this.id + ", active=" + this.active + ", fromPortActive=" + this.fromPortActive + ", fromNode=" + this.fromNode + ", toNode=" + this.toNode + "]";
    }
}

