/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.datamanager.NodeRecord;
import com.intel.stl.datamanager.TopologyNodeId;
import com.intel.stl.datamanager.TopologyRecord;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="TOPOLOGIES_NODES", indexes={@Index(name="IDX_NODE_LID", columnList="lid")})
public class TopologyNodeRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TopologyNodeId id = new TopologyNodeId();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="topologyId", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_TOPOLOGYNODE_TOPOLOGY"))
    private TopologyRecord topology;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeGUID", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_TOPOLOGYNODE_NODE"))
    private NodeRecord node;
    @Transient
    private boolean lidChanged = false;
    private int lid;
    private boolean active = true;

    public TopologyNodeId getId() {
        return this.id;
    }

    public void setId(TopologyNodeId id) {
        this.id = id;
    }

    public TopologyRecord getTopology() {
        return this.topology;
    }

    public void setTopology(TopologyRecord topology) {
        this.topology = topology;
        this.id.setTopologyId(topology.getId());
    }

    public NodeRecord getNode() {
        this.node.getNode().setActive(this.active);
        this.node.getNode().setLid(this.lid);
        return this.node;
    }

    public void setNode(NodeRecord node) {
        this.node = node;
        this.id.setTopologyNode(node.getNodeGUID());
    }

    public boolean isLidChanged() {
        return this.lidChanged;
    }

    public void setLidChanged(boolean lidChanged) {
        this.lidChanged = lidChanged;
    }

    public int getLid() {
        return this.lid;
    }

    public void setLid(int lid) {
        this.lid = lid;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopologyNodeRecord other = (TopologyNodeRecord)obj;
        if (this.active != other.active) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "TopologyNodeRecord [id=" + this.id + ", lidChanged=" + this.lidChanged + ", lid=" + this.lid + ", active=" + this.active + ", node=" + this.node + "]";
    }
}

