/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager.impl;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.datamanager.UserRecord;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.persistence.TypedQuery;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.ReturningWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMigrationHelper {
    private static Logger log = LoggerFactory.getLogger(DatabaseMigrationHelper.class);
    private static final String INSERT_SUBNETRECORD = "INSERT INTO SUBNETS (subnetId, uniqueName, port, autoConnect, secureConnect, statusTimestamp) VALUES(?, ?, ?, ?, ?, ?)";
    private static final String INSERT_USERRECORD = "INSERT INTO USERS (subnetId, userName, lastUpdate, userDescription, userOptionXml) VALUES(?, ?, ?, ?, ?)";

    public static boolean checkTable(EntityManager em, Class<?> tableClass) throws HibernateException {
        Table table = tableClass.getAnnotation(Table.class);
        final String tableName = table.name();
        Boolean res = (Boolean)((Session)em.unwrap(Session.class)).doReturningWork((ReturningWork)new ReturningWork<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean execute(Connection conn) throws SQLException {
                boolean result = false;
                try (ResultSet rs = conn.getMetaData().getTables(null, null, tableName, null);){
                    result = rs.next();
                }
                return result;
            }
        });
        return res;
    }

    public static List<SubnetRecord> getSubnetRecords(EntityManager em) {
        if (!DatabaseMigrationHelper.checkTable(em, SubnetRecord.class)) {
            return null;
        }
        TypedQuery query = em.createNamedQuery("Subnet.All", SubnetRecord.class);
        return query.getResultList();
    }

    public static List<UserRecord> getUserRecords(EntityManager em) {
        if (!DatabaseMigrationHelper.checkTable(em, UserRecord.class)) {
            return null;
        }
        TypedQuery query = em.createNamedQuery("User.All", UserRecord.class);
        return query.getResultList();
    }

    public static SubnetRecord insertSubnetRecord(EntityManager em, SubnetRecord subnet) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        String subnetName = subnet.getSubnetDescription().getName();
        String uniqueName = subnet.getUniqueName();
        List<HostInfo> feList = subnet.getSubnetDescription().getFeList();
        ArrayList<HostInfo> newfeList = new ArrayList<HostInfo>(feList);
        subnet.getSubnetDescription().setFeList(newfeList);
        em.persist((Object)subnet);
        try {
            tx.commit();
            TypedQuery query = em.createNamedQuery("Subnet.findByName", SubnetRecord.class);
            query.setParameter("subnetName", (Object)uniqueName);
            return (SubnetRecord)query.getSingleResult();
        }
        catch (Exception e) {
            log.error("Could not save previously defined subnet '" + subnetName + "': " + StringUtils.getErrorMessage(e), (Throwable)e);
            return null;
        }
    }

    public static void insertUserRecord(EntityManager em, UserRecord user) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        em.persist((Object)user);
        try {
            tx.commit();
        }
        catch (Exception e) {
            log.error("Could not save previously defined user settings '" + user.getId() + "': " + StringUtils.getErrorMessage(e), (Throwable)e);
        }
    }

    public static void insertSpecialRecord(EntityManager em, SubnetRecord subnet) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        Query query = em.createNativeQuery(INSERT_SUBNETRECORD);
        query.setParameter(1, (Object)subnet.getId());
        query.setParameter(2, (Object)subnet.getUniqueName());
        SubnetDescription desc = subnet.getSubnetDescription();
        query.setParameter(3, (Object)desc.getCurrentFE().getPort());
        query.setParameter(4, (Object)desc.isAutoConnect());
        query.setParameter(5, (Object)desc.getCurrentFE().isSecureConnect());
        query.setParameter(6, (Object)desc.getStatusTimestamp());
        try {
            System.out.println("Inserting special record");
            query.executeUpdate();
            System.out.println("Execute done");
            tx.commit();
        }
        catch (Exception e) {
            log.error("Could not insert special record '" + subnet.getId() + "': " + StringUtils.getErrorMessage(e), (Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

