/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.failure.FailureManager;
import com.intel.stl.api.failure.IFailureManagement;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.DatabaseEngine;
import com.intel.stl.dbengine.DatabaseServer;
import com.intel.stl.dbengine.impl.DatabaseContextImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseServerImpl
implements DatabaseServer {
    private static Logger log = LoggerFactory.getLogger(DatabaseServerImpl.class);
    protected static final long UNUSED_THRESHOLD = 600000L;
    private final DatabaseEngine engine;
    private final Map<String, DatabaseContextImpl> dbContexts = new ConcurrentHashMap<String, DatabaseContextImpl>(8, 0.9f, 1);

    public DatabaseServerImpl(DatabaseEngine engine) {
        this.engine = engine;
    }

    @Override
    public DatabaseContext getDatabaseContext(String contextName) {
        DatabaseContextImpl ctx = this.dbContexts.get(contextName);
        if (ctx == null) {
            ctx = this.createDatabaseContext(contextName);
        }
        ctx.setLastUsed(System.currentTimeMillis());
        return ctx;
    }

    @Override
    public void addDatabaseContext(String contextName) {
        Iterator<Map.Entry<String, DatabaseContextImpl>> iterator = this.dbContexts.entrySet().iterator();
        while (iterator.hasNext()) {
            long lastUsed;
            Map.Entry<String, DatabaseContextImpl> entry = iterator.next();
            if (entry.getKey().equals(contextName)) {
                entry.getValue().getEntityManager().close();
                iterator.remove();
                continue;
            }
            long now = System.currentTimeMillis();
            if (now - (lastUsed = entry.getValue().getLastUsed()) <= 600000L) continue;
            entry.getValue().getEntityManager().close();
            iterator.remove();
        }
        this.createDatabaseContext(contextName);
    }

    private DatabaseContextImpl createDatabaseContext(String contextName) {
        EntityManager em = null;
        try {
            em = this.engine.getEntityManager();
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        IFailureManagement failureMgr = FailureManager.getManager();
        DatabaseContextImpl ctx = new DatabaseContextImpl(em, failureMgr);
        ctx.setLastUsed(System.currentTimeMillis());
        this.dbContexts.put(contextName, ctx);
        return ctx;
    }

    protected Map<String, DatabaseContextImpl> getDbContexts() {
        return this.dbContexts;
    }
}

