/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.common.AppDataUtils;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.datamanager.AppInfoRecord;
import com.intel.stl.dbengine.DatabaseEngine;
import com.intel.stl.xml.UserOptions;
import com.intel.stl.xml.UserOptionsMarshaller;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.xml.bind.JAXBException;
import org.hibernate.Hibernate;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateEngine
implements DatabaseEngine {
    private static Logger log = LoggerFactory.getLogger(HibernateEngine.class);
    private static final String DB_ENGINE_NAME = "Hibernate";
    private static final String DB_ENGINE_VERSION = "4.3";
    private static final String APP_INFO_KEY = "FMGuiApp";
    private static final String PERSISTENCE_UNIT = "FMGui";
    private static final String PERSISTENCE_PROVIDER = "javax.persistence.provider";
    private static final String PERSISTENCE_JDBC_DRIVER = "javax.persistence.jdbc.driver";
    private static final String PERSISTENCE_JDBC_URL = "javax.persistence.jdbc.url";
    private static final String PERSISTENCE_JDBC_USER = "javax.persistence.jdbc.user";
    private static final String PERSISTENCE_JDBC_PASS = "javax.persistence.jdbc.password";
    private static final String PERSISTENCE_SCHEMA_GENERATION = "javax.persistence.schema-generation.scripts.action";
    private static final String PERSISTENCE_DATABASE_GENERATION = "javax.persistence.schema-generation.database.action";
    private static final String PERSISTENCE_SCHEMA_DROP_TARGET = "javax.persistence.schema-generation.scripts.drop-target";
    private static final String PERSISTENCE_SCHEMA_CREATE_TARGET = "javax.persistence.schema-generation.scripts.create-target";
    private static final String PERSISTENCE_DATABASE_NAME = "javax.persistence.database-product-name";
    private static final String PERSISTENCE_DATABASE_MAJOR_VERSION = "javax.persistence.database-major-version";
    private static final String PERSISTENCE_DATABASE_MINOR_VERSION = "javax.persistence.database-minor-version";
    public static final String HIBERNATE_SCHEMA_UPDATE = "hibernate.hbm2ddl.auto";
    public static final String HIBERNATE_SHOW_SQL = "hibernate.show_sql";
    public static final String HIBERNATE_FORMAT_SQL = "hibernate.format_sql";
    private static final String DB_SETTING_PREFIX = "db.";
    private final AppSettings settings;
    private final String persistenceProvider;
    private final String providerName;
    private final String dbmsName;
    private final String connectionDriver;
    private final String connectionUrl;
    private final String connectionUser;
    private final String connectionPass;
    private EntityManagerFactory factory;

    public HibernateEngine(AppSettings settings) {
        this.settings = settings;
        this.persistenceProvider = this.getSetting("db.persistence.provider");
        this.providerName = this.getSetting("db.persistence.provider.name");
        this.dbmsName = this.getSetting("db.database.provider.name");
        this.connectionDriver = this.getSetting("db.connection.driver");
        String dbmsProps = this.createDBMSPropertiesString();
        String connectionUrl = this.getSetting("db.connection.url");
        if (connectionUrl == null) {
            String appDbFolder = this.getSetting("app.db.path");
            String dbFullName = appDbFolder == null ? this.getSetting("db.name") : appDbFolder + File.separatorChar + this.getSetting("db.name");
            this.connectionUrl = "jdbc:hsqldb:file:" + dbFullName + ";" + dbmsProps;
        } else {
            this.connectionUrl = connectionUrl;
        }
        this.connectionUser = this.getSetting("db.connection.user");
        this.connectionPass = this.getSetting("db.connection.password");
    }

    @Override
    public void start() {
        Map<String, Object> overrides = this.createOverrides();
        this.factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT, overrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean compact) {
        EntityManager em = this.factory.createEntityManager();
        String shutdown = "SHUTDOWN";
        if (compact) {
            shutdown = "SHUTDOWN COMPACT";
            log.info("Database will be compacted during shutdown");
        }
        try {
            em.getTransaction().begin();
            log.info("Hibernate engine shutting down...");
            em.createNativeQuery(shutdown).executeUpdate();
            em.getTransaction().commit();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.factory.close();
        }
    }

    @Override
    public EntityManager getEntityManager() throws DatabaseException {
        if (this.factory == null) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30016_ENGINE_NOT_STARTED, DB_ENGINE_NAME);
            throw dbe;
        }
        EntityManager em = this.factory.createEntityManager();
        em.setFlushMode(FlushModeType.COMMIT);
        return em;
    }

    @Override
    public Connection getConnection() throws DatabaseException {
        return null;
    }

    @Override
    public AppInfo getAppInfo() {
        AppInfoRecord appInfoRec;
        AppInfo appInfo = null;
        try {
            EntityManager em = this.getEntityManager();
            appInfoRec = (AppInfoRecord)em.find(AppInfoRecord.class, (Object)APP_INFO_KEY);
            if (appInfoRec == null) {
                return appInfo;
            }
            appInfo = appInfoRec.getAppInfo();
        }
        catch (DatabaseException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (PersistenceException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLGrammarException) {
                SQLGrammarException ge = (SQLGrammarException)cause;
                log.debug(cause.getMessage() + "; SQL Error Code: " + ge.getSQLException().getErrorCode() + ", SQL State: " + ge.getSQLException().getSQLState(), (Throwable)ge.getSQLException());
            } else {
                log.debug(e.getMessage(), e.getCause());
            }
            return null;
        }
        try {
            UserOptions options = UserOptionsMarshaller.unmarshal(appInfoRec.getPropertiesXml());
            appInfo.setPropertiesMap(options.getPreferences());
            return appInfo;
        }
        catch (JAXBException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return appInfo;
        }
    }

    @Override
    public void saveAppInfo(AppInfo appInfo) {
        String propertiesXml = AppDataUtils.getDefaultUserOptions();
        try {
            UserOptions options = UserOptionsMarshaller.unmarshal(propertiesXml);
            options.setPreferences(appInfo.getPropertiesMap());
            propertiesXml = UserOptionsMarshaller.marshal(options);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        EntityManager em = this.getEntityManager();
        AppInfoRecord record = (AppInfoRecord)em.find(AppInfoRecord.class, (Object)APP_INFO_KEY);
        em.getTransaction().begin();
        if (record == null) {
            record = new AppInfoRecord();
            record.setAppId(APP_INFO_KEY);
            record.setAppInfo(appInfo);
            record.setPropertiesXml(propertiesXml);
            em.persist((Object)record);
        } else {
            record.setAppInfo(appInfo);
            record.setPropertiesXml(propertiesXml);
            em.merge((Object)record);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getUser() {
        return this.connectionUser;
    }

    @Override
    public String getEngineName() {
        return DB_ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return DB_ENGINE_VERSION;
    }

    @Override
    public void updateSchema() throws AppConfigurationException {
        String appDbFolder;
        String ddlFileName;
        File ddlFile;
        if (this.factory != null) {
            this.factory.close();
        }
        if ((ddlFile = new File(ddlFileName = (appDbFolder = this.getSetting("app.db.path")) == null ? this.getSetting("db.name") + ".sql" : appDbFolder + File.separatorChar + this.getSetting("db.name") + ".sql")).exists()) {
            ddlFile.delete();
        }
        Map<String, Object> overrides = this.createOverrides();
        overrides.put(HIBERNATE_SCHEMA_UPDATE, "create");
        overrides.put(PERSISTENCE_DATABASE_GENERATION, "drop-and-create");
        overrides.put(PERSISTENCE_SCHEMA_GENERATION, "drop-and-create");
        overrides.put(PERSISTENCE_SCHEMA_DROP_TARGET, ddlFileName);
        overrides.put(PERSISTENCE_SCHEMA_CREATE_TARGET, ddlFileName);
        this.factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT, overrides);
    }

    public static <T> T unproxy(T entity) {
        Object unproxiedEntity = entity;
        Hibernate.initialize(unproxiedEntity);
        if (entity instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)unproxiedEntity;
            LazyInitializer initializer = proxy.getHibernateLazyInitializer();
            unproxiedEntity = initializer.getImplementation();
        }
        return unproxiedEntity;
    }

    private Map<String, Object> createOverrides() {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        this.applySetting(overrides, PERSISTENCE_PROVIDER, this.persistenceProvider);
        this.applySetting(overrides, PERSISTENCE_JDBC_DRIVER, this.connectionDriver);
        this.applySetting(overrides, PERSISTENCE_JDBC_URL, this.connectionUrl);
        this.applySetting(overrides, PERSISTENCE_JDBC_USER, this.connectionUser);
        this.applySetting(overrides, PERSISTENCE_JDBC_PASS, this.connectionPass);
        if (this.providerName != null) {
            String providerSettingPrefix = DB_SETTING_PREFIX + this.providerName + ".";
            for (Object setting : this.settings.keySet()) {
                String settingName = setting.toString().toLowerCase();
                if (!settingName.startsWith(providerSettingPrefix)) continue;
                String configOption = this.getSetting((String)setting);
                this.applySetting(overrides, settingName.substring(DB_SETTING_PREFIX.length()), configOption);
            }
        }
        return overrides;
    }

    private String createDBMSPropertiesString() {
        StringBuffer props = new StringBuffer();
        if (this.dbmsName != null) {
            String dbmsSettingPrefix = DB_SETTING_PREFIX + this.dbmsName + ".";
            for (Object setting : this.settings.keySet()) {
                String settingName = setting.toString().toLowerCase();
                if (!settingName.startsWith(dbmsSettingPrefix)) continue;
                String configOption = this.getSetting((String)setting);
                props.append(settingName.substring(dbmsSettingPrefix.length()));
                props.append('=');
                props.append(configOption);
                props.append(';');
            }
        }
        log.info("DB Properties: '" + props.toString() + "'");
        return props.toString();
    }

    public void generateScripts(String targetDatabase, int targetMajorVersion, int targetMinorVersion, String targetFile) throws AppConfigurationException {
        File outFile = new File(targetFile);
        if (outFile.exists()) {
            outFile.delete();
        }
        String outFilePath = outFile.getAbsolutePath();
        Map<String, Object> overrides = this.createOverrides();
        overrides.put(PERSISTENCE_SCHEMA_GENERATION, "drop-and-create");
        overrides.put(PERSISTENCE_SCHEMA_DROP_TARGET, outFilePath);
        overrides.put(PERSISTENCE_SCHEMA_CREATE_TARGET, outFilePath);
        overrides.put(PERSISTENCE_DATABASE_GENERATION, "none");
        overrides.put(PERSISTENCE_DATABASE_NAME, targetDatabase);
        overrides.put(PERSISTENCE_DATABASE_MAJOR_VERSION, "" + targetMajorVersion);
        overrides.put(PERSISTENCE_DATABASE_MINOR_VERSION, "" + targetMinorVersion);
        Persistence.generateSchema((String)PERSISTENCE_UNIT, overrides);
    }

    private String getSetting(String option) {
        try {
            return this.settings.getConfigOption(option);
        }
        catch (AppConfigurationException e) {
            return null;
        }
    }

    private void applySetting(Map<String, Object> map, String settingName, Object settingValue) {
        if (settingValue == null) {
            return;
        }
        log.debug("Overriding '" + settingName + "' = " + settingValue);
        map.put(settingName, settingValue);
    }
}

