/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.configuration.PortState;
import com.intel.stl.api.notice.GenericNoticeAttrBean;
import com.intel.stl.api.notice.NoticeAttrBean;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.VendorNoticeAttrBean;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.GenericNoticeRecord;
import com.intel.stl.datamanager.NodeRecord;
import com.intel.stl.datamanager.NodeTypeRecord;
import com.intel.stl.datamanager.NoticeRecord;
import com.intel.stl.datamanager.NoticeStatus;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.datamanager.TopologyLinkId;
import com.intel.stl.datamanager.TopologyLinkRecord;
import com.intel.stl.datamanager.TopologyNodeId;
import com.intel.stl.datamanager.TopologyNodeRecord;
import com.intel.stl.datamanager.TopologyRecord;
import com.intel.stl.datamanager.VendorNoticeRecord;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.NoticeDAO;
import com.intel.stl.dbengine.SubnetDAO;
import com.intel.stl.dbengine.impl.BaseDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeDAOImpl
extends BaseDAO
implements NoticeDAO {
    private static Logger log = LoggerFactory.getLogger((String)"org.hibernate.SQL");
    protected static int BATCH_SIZE = 100;
    private final SubnetDAO subnetDAO;

    public NoticeDAOImpl(EntityManager entityManager, DatabaseContext databaseCtx) {
        super(entityManager, databaseCtx);
        this.subnetDAO = databaseCtx.getSubnetDAO();
    }

    @Override
    public List<NoticeRecord> saveNotices(SubnetRecord subnetRec, NoticeBean[] notices) {
        ArrayList<NoticeRecord> noticeRecords = new ArrayList<NoticeRecord>();
        NoticeRecord noticeRec = null;
        for (NoticeBean notice : notices) {
            noticeRec = this.createNoticeRecord(subnetRec, notice);
            noticeRecords.add(noticeRec);
        }
        return noticeRecords;
    }

    @Override
    public Boolean processNotices(SubnetRecord subnet, List<NoticeProcess> notices) {
        boolean topologyChanged;
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30025_TOPOLOGY_NOT_FOUND, subnet.getSubnetDescription().getName());
            throw dbe;
        }
        HashSet<NodeRecord> newNodes = new HashSet<NodeRecord>();
        HashSet<TopologyNodeRecord> newTopoNodes = new HashSet<TopologyNodeRecord>();
        HashSet<TopologyLinkRecord> newLinks = new HashSet<TopologyLinkRecord>();
        HashSet<TopologyNodeRecord> currTopoNodes = new HashSet<TopologyNodeRecord>();
        HashSet<TopologyLinkRecord> currLinks = new HashSet<TopologyLinkRecord>();
        this.prepareDatabaseData(topology, notices, newNodes, newTopoNodes, newLinks, currTopoNodes, currLinks);
        boolean bl = topologyChanged = newTopoNodes.size() > 0 || newLinks.size() > 0;
        if (topologyChanged) {
            this.insertNewNodes(newNodes);
            this.subnetDAO.copyTopology(subnet, newTopoNodes, currTopoNodes, newLinks, currLinks);
        } else {
            this.updateTopology(newNodes, newTopoNodes, currTopoNodes, newLinks, currLinks);
        }
        return topologyChanged;
    }

    @Override
    public List<NoticeBean> getNotices(SubnetRecord subnet, NoticeStatus status) {
        List<NoticeRecord> noticeRecords = this.readNoticeRecords(subnet, status);
        ArrayList<NoticeBean> noticeBeans = new ArrayList<NoticeBean>();
        if (noticeRecords == null || noticeRecords.size() == 0) {
            return noticeBeans;
        }
        for (NoticeRecord notice : noticeRecords) {
            noticeBeans.add(notice.getNotice());
        }
        return noticeBeans;
    }

    @Override
    public List<NoticeBean> getNotices(SubnetRecord subnet, NoticeStatus status, NoticeStatus newStatus) {
        List<NoticeRecord> noticeRecords = this.readNoticeRecords(subnet, status);
        ArrayList<NoticeBean> noticeBeans = new ArrayList<NoticeBean>();
        if (noticeRecords == null || noticeRecords.size() == 0) {
            return noticeBeans;
        }
        for (NoticeRecord notice : noticeRecords) {
            this.startTransaction();
            notice.setNoticeStatus(newStatus);
            this.em.merge((Object)notice);
            try {
                this.commitTransaction();
                noticeBeans.add(notice.getNotice());
            }
            catch (Exception e) {
                log.info(e.getMessage(), (Throwable)e);
            }
        }
        return noticeBeans;
    }

    @Override
    public void resetNotices(SubnetRecord subnet) {
        List<NoticeRecord> rcvdRecs = this.readNoticeRecords(subnet, NoticeStatus.RECEIVED);
        List<NoticeRecord> inflightRecs = this.readNoticeRecords(subnet, NoticeStatus.INFLIGHT);
        if (rcvdRecs.size() > 0 || inflightRecs.size() > 0) {
            int updates = 0;
            this.startTransaction();
            for (NoticeRecord notice : rcvdRecs) {
                updates = this.resetNotice(notice, updates);
            }
            for (NoticeRecord notice : inflightRecs) {
                updates = this.resetNotice(notice, updates);
            }
            if (updates > 0) {
                this.flush();
                this.clear();
            }
            this.commitTransaction();
        }
    }

    @Override
    public void updateNotice(SubnetRecord subnet, long noticeId, NoticeStatus noticeStatus) {
        TypedQuery query = this.em.createNamedQuery("NoticeRecord.findById", NoticeRecord.class);
        query.setParameter("subnetId", (Object)subnet.getId());
        query.setParameter("id", (Object)noticeId);
        List noticeRecs = query.getResultList();
        NoticeRecord notice = (NoticeRecord)noticeRecs.get(0);
        notice.setNoticeStatus(noticeStatus);
        this.startTransaction();
        this.em.merge((Object)notice);
        this.commitTransaction();
    }

    private void prepareDatabaseData(TopologyRecord topology, List<NoticeProcess> notices, Set<NodeRecord> newNodes, Set<TopologyNodeRecord> newTopoNodes, Set<TopologyLinkRecord> newLinks, Set<TopologyNodeRecord> currTopoNodes, Set<TopologyLinkRecord> currLinks) {
        for (NoticeProcess notice : notices) {
            int lid = notice.getLid();
            NodeRecordBean node = notice.getNode();
            if (node != null) {
                this.prepareNodeData(topology, notice, newNodes, newTopoNodes, currTopoNodes);
                this.prepareLinkData(topology, notice, newLinks, currLinks);
                continue;
            }
            log.error("Could not find node information for lid: " + lid);
        }
    }

    private void prepareNodeData(TopologyRecord topology, NoticeProcess notice, Set<NodeRecord> newNodes, Set<TopologyNodeRecord> newTopoNodes, Set<TopologyNodeRecord> currTopoNodes) {
        TopologyNodeRecord topoNode;
        NodeRecordBean node = notice.getNode();
        long nodeGUID = node.getNodeInfo().getNodeGUID();
        int lid = node.getLid();
        NodeRecord nodeRec = (NodeRecord)this.em.find(NodeRecord.class, (Object)nodeGUID);
        boolean topoNodeInSet = false;
        if (nodeRec == null) {
            nodeRec = new NodeRecord(node);
            nodeRec.setType(this.getNodeTypeReference(node));
            newNodes.add(nodeRec);
            topoNode = this.createTopologyNode(topology, nodeRec, lid);
            newTopoNodes.add(topoNode);
            topoNodeInSet = true;
        } else {
            TopologyNodeId id = new TopologyNodeId();
            id.setTopologyId(topology.getId());
            id.setTopologyNode(nodeGUID);
            topoNode = (TopologyNodeRecord)this.em.find(TopologyNodeRecord.class, (Object)id);
            if (topoNode == null) {
                nodeRec.getNode();
                topoNode = this.createTopologyNode(topology, nodeRec, lid);
                newTopoNodes.add(topoNode);
                topoNodeInSet = true;
            } else {
                topoNode.setLid(lid);
            }
        }
        switch (notice.getTrapType()) {
            case GID_NOW_IN_SERVICE: {
                topoNode.setActive(true);
                if (topoNodeInSet) break;
                currTopoNodes.add(topoNode);
                break;
            }
            case GID_OUT_OF_SERVICE: {
                topoNode.setActive(false);
                if (topoNodeInSet) break;
                currTopoNodes.add(topoNode);
                break;
            }
            case LINK_PORT_CHANGE_STATE: {
                break;
            }
        }
    }

    private TopologyNodeRecord createTopologyNode(TopologyRecord topology, NodeRecord node, int lid) {
        TopologyNodeRecord topoNode = new TopologyNodeRecord();
        topoNode.setTopology(topology);
        topoNode.setNode(node);
        topoNode.setLid(lid);
        return topoNode;
    }

    private void prepareLinkData(TopologyRecord topology, NoticeProcess notice, Set<TopologyLinkRecord> newLinks, Set<TopologyLinkRecord> currLinks) {
        Set<TopologyLinkRecord> dbLinks = this.getTopologyLinkRecords(topology, notice);
        Set<TopologyLinkRecord> fmLinks = this.getLinkSet(topology, notice);
        fmLinks.removeAll(dbLinks);
        newLinks.addAll(fmLinks);
        currLinks.addAll(dbLinks);
    }

    private Set<TopologyLinkRecord> getLinkSet(TopologyRecord topology, NoticeProcess notice) {
        List<LinkRecordBean> links = notice.getLinks();
        if (links == null) {
            return new HashSet<TopologyLinkRecord>();
        }
        HashSet<TopologyLinkRecord> linkSet = new HashSet<TopologyLinkRecord>(links.size());
        switch (notice.getTrapType()) {
            case GID_NOW_IN_SERVICE: {
                this.createLinkRecordsAndSetStatus(topology, notice, linkSet, true);
                break;
            }
            case GID_OUT_OF_SERVICE: {
                this.createLinkRecordsAndSetStatus(topology, notice, linkSet, false);
                break;
            }
            case LINK_PORT_CHANGE_STATE: {
                HashMap<Short, PortState> portMap = new HashMap<Short, PortState>();
                for (PortRecordBean port : notice.getPorts()) {
                    PortState portState = port.getPortInfo().getPortStates().getPortState();
                    portMap.put(port.getPortNum(), portState);
                }
                this.createLinkRecordsUsingPortStatus(topology, notice, linkSet, portMap);
                break;
            }
        }
        return linkSet;
    }

    private void createLinkRecordsAndSetStatus(TopologyRecord topology, NoticeProcess notice, Set<TopologyLinkRecord> linkSet, boolean status) {
        List<LinkRecordBean> links = notice.getLinks();
        int lid = notice.getLid();
        long topologyId = topology.getId();
        long nodeGUID = notice.getNode().getNodeInfo().getNodeGUID();
        for (LinkRecordBean link : links) {
            TopologyLinkRecord topoLink = this.createTopologyLink(link, topologyId, nodeGUID, lid);
            if (topoLink == null) continue;
            topoLink.setActive(status);
            linkSet.add(topoLink);
        }
    }

    private void createLinkRecordsUsingPortStatus(TopologyRecord topology, NoticeProcess notice, Set<TopologyLinkRecord> linkSet, Map<Short, PortState> portMap) {
        List<LinkRecordBean> links = notice.getLinks();
        int lid = notice.getLid();
        long topologyId = topology.getId();
        long nodeGUID = notice.getNode().getNodeInfo().getNodeGUID();
        for (LinkRecordBean link : links) {
            TopologyLinkRecord topoLink = this.createTopologyLink(link, topologyId, nodeGUID, lid);
            if (topoLink == null) continue;
            PortState portState = link.getFromLID() == lid ? portMap.get(link.getFromPortIndex()) : portMap.get(link.getToPortIndex());
            if (portState == PortState.ACTIVE) {
                topoLink.setActive(true);
            } else {
                topoLink.setActive(false);
            }
            linkSet.add(topoLink);
        }
    }

    private TopologyLinkRecord createTopologyLink(LinkRecordBean link, long topologyId, long nodeGUID, int lid) {
        TopologyLinkRecord topoLink = new TopologyLinkRecord(link);
        TopologyLinkId id = topoLink.getId();
        id.setLinkTopology(topologyId);
        int fromLid = link.getFromLID();
        int toLid = link.getToLID();
        if (fromLid == lid) {
            id.setSourceNode(nodeGUID);
            TopologyNodeRecord topoNode = this.subnetDAO.getTopologyNodeRecord(topologyId, toLid);
            if (topoNode == null) {
                log.info("Cannot add link because lid '" + toLid + "' is not yet in database: " + link);
                return null;
            }
            id.setTargetNode(topoNode.getNode().getNodeGUID());
            return topoLink;
        }
        if (toLid == lid) {
            id.setTargetNode(nodeGUID);
            TopologyNodeRecord topoNode = this.subnetDAO.getTopologyNodeRecord(topologyId, fromLid);
            if (topoNode == null) {
                log.info("Cannot add link because lid '" + fromLid + "' is not yet in database: " + link);
                return null;
            }
            id.setSourceNode(topoNode.getNode().getNodeGUID());
            return topoLink;
        }
        log.error("Link is not related to lid '" + lid + "': " + link);
        return null;
    }

    private Set<TopologyLinkRecord> getTopologyLinkRecords(TopologyRecord topology, NoticeProcess notice) {
        long nodeGUID;
        long topologyId = topology.getId();
        List<TopologyLinkRecord> links = this.subnetDAO.getTopologyLinkRecords(topologyId, nodeGUID = notice.getNode().getNodeInfo().getNodeGUID());
        if (links == null) {
            return new HashSet<TopologyLinkRecord>();
        }
        HashSet<TopologyLinkRecord> linkSet = new HashSet<TopologyLinkRecord>(links.size() * 2);
        switch (notice.getTrapType()) {
            case GID_NOW_IN_SERVICE: {
                this.populateLinkSetAndSetStatus(links, linkSet, true);
                break;
            }
            case GID_OUT_OF_SERVICE: {
                this.populateLinkSetAndSetStatus(links, linkSet, false);
                break;
            }
            case LINK_PORT_CHANGE_STATE: {
                HashMap<Short, PortState> portMap = new HashMap<Short, PortState>();
                for (PortRecordBean port : notice.getPorts()) {
                    PortState portState = port.getPortInfo().getPortStates().getPortState();
                    portMap.put(port.getPortNum(), portState);
                }
                this.populateLinkSetUsingPortStatus(links, linkSet, portMap);
                break;
            }
        }
        return linkSet;
    }

    private void populateLinkSetAndSetStatus(List<TopologyLinkRecord> links, Set<TopologyLinkRecord> linkSet, boolean status) {
        for (TopologyLinkRecord topoLink : links) {
            TopologyLinkId id = topoLink.getId();
            TopologyLinkId revId = new TopologyLinkId();
            revId.setLinkTopology(id.getLinkTopology());
            revId.setSourceNode(id.getTargetNode());
            revId.setSourcePort(id.getTargetPort());
            revId.setTargetNode(id.getSourceNode());
            revId.setTargetPort(id.getSourcePort());
            TopologyLinkRecord revTopoLink = (TopologyLinkRecord)this.em.find(TopologyLinkRecord.class, (Object)revId);
            if (revTopoLink == null) {
                revTopoLink = new TopologyLinkRecord();
                revTopoLink.setId(revId);
            }
            revTopoLink.setActive(status);
            linkSet.add(revTopoLink);
            topoLink.setActive(status);
            linkSet.add(topoLink);
        }
    }

    private void populateLinkSetUsingPortStatus(List<TopologyLinkRecord> links, Set<TopologyLinkRecord> linkSet, Map<Short, PortState> portMap) {
        for (TopologyLinkRecord topoLink : links) {
            TopologyLinkId id = topoLink.getId();
            TopologyLinkId revId = new TopologyLinkId();
            revId.setLinkTopology(id.getLinkTopology());
            revId.setSourceNode(id.getTargetNode());
            revId.setSourcePort(id.getTargetPort());
            revId.setTargetNode(id.getSourceNode());
            revId.setTargetPort(id.getSourcePort());
            TopologyLinkRecord revTopoLink = (TopologyLinkRecord)this.em.find(TopologyLinkRecord.class, (Object)revId);
            PortState portState = portMap.get(id.getSourcePort());
            if (portState == PortState.ACTIVE) {
                topoLink.setActive(true);
                if (revTopoLink != null) {
                    revTopoLink.setActive(true);
                }
            } else {
                topoLink.setActive(false);
                if (revTopoLink != null) {
                    revTopoLink.setActive(false);
                }
            }
            linkSet.add(topoLink);
            if (revTopoLink == null) continue;
            linkSet.add(revTopoLink);
        }
    }

    private void updateTopology(Set<NodeRecord> newNodes, Set<TopologyNodeRecord> newTopoNodes, Set<TopologyNodeRecord> currTopoNodes, Set<TopologyLinkRecord> newTopoLinks, Set<TopologyLinkRecord> currTopoLinks) {
        this.insertNewNodes(newNodes);
        this.startTransaction();
        for (TopologyNodeRecord topoNode : newTopoNodes) {
            this.em.persist((Object)topoNode);
        }
        for (TopologyLinkRecord topoLink : newTopoLinks) {
            this.em.persist((Object)topoLink);
        }
        for (TopologyNodeRecord topoNode : currTopoNodes) {
            this.em.merge((Object)topoNode);
        }
        for (TopologyLinkRecord topoLink : currTopoLinks) {
            this.em.merge((Object)topoLink);
        }
        this.commitTransaction();
    }

    private void insertNewNodes(Set<NodeRecord> newNodes) {
        if (newNodes.size() > 0) {
            this.startTransaction();
            for (NodeRecord node : newNodes) {
                this.em.persist((Object)node);
            }
            this.commitTransaction();
        }
    }

    private NoticeRecord createNoticeRecord(SubnetRecord subnetRec, NoticeBean noticeBean) {
        NoticeRecord noticeRec = null;
        NoticeAttrBean attr = noticeBean.getAttributes();
        if (attr.isGeneric()) {
            noticeRec = new GenericNoticeRecord();
            ((GenericNoticeRecord)noticeRec).setGenericNoticeAttr((GenericNoticeAttrBean)attr);
        } else {
            noticeRec = new VendorNoticeRecord();
            ((VendorNoticeRecord)noticeRec).setVendorNoticeAttr((VendorNoticeAttrBean)attr);
        }
        noticeRec.setNoticeStatus(NoticeStatus.RECEIVED);
        noticeRec.setNotice(noticeBean);
        noticeRec.setSubnet(subnetRec);
        this.startTransaction();
        this.em.persist((Object)noticeRec);
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            this.throwPersistDatabaseException(e, "NoticeRecord", noticeRec.getId().getNoticeId());
        }
        return noticeRec;
    }

    private List<NoticeRecord> readNoticeRecords(SubnetRecord subnet, NoticeStatus status) {
        TypedQuery query = this.em.createNamedQuery("NoticeRecord.findBySubnet", NoticeRecord.class);
        query.setParameter("subnetId", (Object)subnet.getId());
        query.setParameter("noticeStatus", (Object)status);
        return query.getResultList();
    }

    private int resetNotice(NoticeRecord notice, int updates) {
        notice.setNoticeStatus(NoticeStatus.PROCESSED);
        this.em.merge((Object)notice);
        if (++updates >= BATCH_SIZE) {
            this.flush();
            this.clear();
            updates = 0;
        }
        return updates;
    }

    private NodeTypeRecord getNodeTypeReference(NodeRecordBean nodeBean) {
        NodeType nodeType = nodeBean.getNodeType();
        if (nodeType == null) {
            throw new RuntimeException("Invalid NodeRecordBean: " + nodeBean);
        }
        return (NodeTypeRecord)this.em.getReference(NodeTypeRecord.class, (Object)nodeType.getId());
    }

    private void throwPersistDatabaseException(Throwable cause, String entity, Object entityId) throws DatabaseException {
        Throwable last = cause;
        while (last.getCause() != null) {
            last = last.getCause();
        }
        DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30013_ERROR_SAVING_ENTITY, cause, entity, entityId, last.getMessage());
        throw dbe;
    }
}

