/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.FMException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.NodeRecord;
import com.intel.stl.datamanager.NodeTypeRecord;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.datamanager.TopologyLinkId;
import com.intel.stl.datamanager.TopologyLinkRecord;
import com.intel.stl.datamanager.TopologyNodeId;
import com.intel.stl.datamanager.TopologyNodeRecord;
import com.intel.stl.datamanager.TopologyRecord;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.SubnetDAO;
import com.intel.stl.dbengine.impl.BaseDAO;
import com.intel.stl.dbengine.impl.DatabaseUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetDAOImpl
extends BaseDAO
implements SubnetDAO {
    private static Logger log = LoggerFactory.getLogger((String)"org.hibernate.SQL");
    private static final String SQLQUERY_LINKS_WITH_LIDS = "SELECT s.lid AS fromLID, l.fromPort, t.lid AS toLID, l.toPort, l.active FROM TOPOLOGIES_LINKS l LEFT JOIN TOPOLOGIES_NODES s ON l.topologyId = s.topologyId AND l.fromNodeGUID = s.nodeGUID LEFT JOIN TOPOLOGIES_NODES t ON l.topologyId = t.topologyId AND l.toNodeGUID = t.nodeGUID WHERE l.topologyId = :topologyId ORDER BY s.lid, l.fromPort";
    protected static int BATCH_SIZE = 1000;

    public SubnetDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public SubnetDAOImpl(EntityManager entityManager, DatabaseContext databaseCtx) {
        super(entityManager, databaseCtx);
    }

    @Override
    public List<SubnetDescription> getSubnets() {
        TypedQuery query = this.em.createNamedQuery("Subnet.All", SubnetRecord.class);
        List records = query.getResultList();
        ArrayList<SubnetDescription> subnets = new ArrayList<SubnetDescription>(records.size());
        for (SubnetRecord record : records) {
            String uniqueName = record.getUniqueName();
            if (!uniqueName.startsWith("1")) continue;
            subnets.add(record.getSubnetDescription());
        }
        return subnets;
    }

    @Override
    public SubnetRecord getSubnet(String subnetName) {
        return this.getSubnet(subnetName, "1");
    }

    @Override
    public SubnetRecord getSubnet(long subnetId) {
        return (SubnetRecord)this.em.find(SubnetRecord.class, (Object)subnetId);
    }

    @Override
    public SubnetDescription defineSubnet(SubnetDescription subnet) {
        SubnetRecord newSubnet = new SubnetRecord();
        newSubnet.setSubnetDescription(subnet);
        String uniqueName = "1" + subnet.getName();
        newSubnet.setUniqueName(uniqueName);
        this.startTransaction();
        this.em.persist((Object)newSubnet);
        try {
            this.commitTransaction();
            TypedQuery query = this.em.createNamedQuery("Subnet.findByName", SubnetRecord.class);
            query.setParameter("subnetName", (Object)("1" + subnet.getName()));
            SubnetDescription savedSubnet = ((SubnetRecord)query.getSingleResult()).getSubnetDescription();
            return savedSubnet;
        }
        catch (Exception e) {
            DatabaseException dbe = this.createPersistException(e, SubnetDescription.class, subnet.getName());
            throw dbe;
        }
    }

    @Override
    public void updateSubnet(SubnetDescription subnet) throws SubnetDataNotFoundException {
        SubnetRecord currSubnet = (SubnetRecord)this.em.find(SubnetRecord.class, (Object)subnet.getSubnetId());
        if (currSubnet == null) {
            throw this.createDataNotFoundException(STLMessages.STL30022_SUBNET_NOT_FOUND, subnet.getName());
        }
        ArrayList<HostInfo> feList = new ArrayList<HostInfo>(subnet.getFeList());
        subnet.setFeList(feList);
        this.startTransaction();
        currSubnet.setSubnetDescription(subnet);
        String uniqueName = "1" + subnet.getName();
        currSubnet.setUniqueName(uniqueName);
        this.em.merge((Object)currSubnet);
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            DatabaseException dbe = this.createPersistException(e, SubnetDescription.class, subnet.getName());
            throw dbe;
        }
    }

    @Override
    public void removeSubnet(long subnetId) throws SubnetDataNotFoundException {
        SubnetRecord currSubnet = (SubnetRecord)this.em.find(SubnetRecord.class, (Object)subnetId);
        if (currSubnet == null) {
            throw this.createDataNotFoundException(STLMessages.STL30022_SUBNET_NOT_FOUND, subnetId);
        }
        this.startTransaction();
        String subnetName = currSubnet.getSubnetDescription().getName();
        String uniqueName = "0" + subnetName + currSubnet.getId();
        currSubnet.setUniqueName(uniqueName);
        this.em.merge((Object)currSubnet);
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            DatabaseException dbe = this.createPersistException(e, SubnetDescription.class, currSubnet.getSubnetDescription().getName() + "(" + currSubnet.getId() + ")");
            throw dbe;
        }
    }

    @Override
    public NodeRecordBean getNode(long guid) {
        NodeRecord node = (NodeRecord)this.em.find(NodeRecord.class, (Object)guid);
        return node.getNode();
    }

    @Override
    public NodeRecordBean getNode(String subnetName, int lid) throws SubnetDataNotFoundException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createNodeTopologyNotFoundException(subnetName);
        }
        TopologyNodeRecord topoNode = this.getTopologyNodeRecordWithException(topology.getId(), lid);
        NodeRecord node = topoNode.getNode();
        NodeRecordBean nodeBean = node.getNode();
        nodeBean.setLid(topoNode.getLid());
        nodeBean.setActive(topoNode.isActive());
        return nodeBean;
    }

    @Override
    public NodeRecordBean getNode(String subnetName, long guid) throws SubnetDataNotFoundException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createNodeTopologyNotFoundException(subnetName);
        }
        TopologyNodeRecord topoNode = this.getTopologyNodeRecord(topology.getId(), guid);
        NodeRecord node = topoNode.getNode();
        NodeRecordBean nodeBean = node.getNode();
        nodeBean.setLid(topoNode.getLid());
        nodeBean.setActive(topoNode.isActive());
        return nodeBean;
    }

    @Override
    public NodeRecordBean getNodeByPortGUID(String subnetName, long portGuid) throws SubnetDataNotFoundException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createNodeTopologyNotFoundException(subnetName);
        }
        TypedQuery query = this.em.createNamedQuery("Node.findByPortGuid", NodeRecord.class);
        query.setParameter("portguid", (Object)portGuid);
        List records = query.getResultList();
        if (records == null || records.size() == 0) {
            throw this.createPortGuidNotFoundException(StringUtils.longHexString(portGuid));
        }
        NodeRecord node = (NodeRecord)records.get(0);
        TopologyNodeRecord topoNode = this.getTopologyNodeRecord(topology.getId(), node.getNodeGUID());
        NodeRecordBean nodeBean = node.getNode();
        nodeBean.setLid(topoNode.getLid());
        nodeBean.setActive(topoNode.isActive());
        return nodeBean;
    }

    @Override
    public void insertNode(NodeRecordBean node) {
        NodeType nodeType = node.getNodeType();
        if (nodeType == null) {
            return;
        }
        this.startTransaction();
        Byte typeValue = nodeType.getId();
        NodeRecord noderec = new NodeRecord(node);
        noderec.setType((NodeTypeRecord)this.em.getReference(NodeTypeRecord.class, (Object)typeValue));
        this.em.persist((Object)noderec);
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            DatabaseException dbe = this.createPersistException(e, NodeRecordBean.class, StringUtils.longHexString(noderec.getNodeGUID()));
            throw dbe;
        }
    }

    @Override
    public void updateNode(NodeRecordBean node) throws SubnetDataNotFoundException {
        long nodeGuid = node.getNodeInfo().getNodeGUID();
        NodeRecord currNode = (NodeRecord)this.em.find(NodeRecord.class, (Object)nodeGuid);
        if (currNode == null) {
            throw this.createNodeNotFoundException("NodeRecordBean", StringUtils.longHexString(nodeGuid));
        }
        this.startTransaction();
        NodeRecordBean nodeBean = currNode.getNode();
        nodeBean.setLid(node.getLid());
        nodeBean.setNodeDesc(node.getNodeDesc());
        nodeBean.setNodeInfo(node.getNodeInfo());
        nodeBean.setActive(node.isActive());
        currNode.setType(this.getNodeTypeReference(nodeBean));
        this.em.merge((Object)currNode);
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            DatabaseException dbe = this.createPersistException(e, NodeRecordBean.class, StringUtils.longHexString(currNode.getNodeGUID()));
            throw dbe;
        }
    }

    @Override
    public List<NodeRecordBean> getNodes(String subnetName) throws SubnetDataNotFoundException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            return new ArrayList<NodeRecordBean>();
        }
        Set<TopologyNodeRecord> topoNodes = topology.getNodes();
        int size = topoNodes.size();
        ArrayList<NodeRecordBean> nodes = new ArrayList<NodeRecordBean>(size);
        for (TopologyNodeRecord topoNode : topoNodes) {
            NodeRecordBean node = topoNode.getNode().getNode();
            node.setLid(topoNode.getLid());
            node.setActive(topoNode.isActive());
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public TopologyRecord saveTopology(String subnetName, List<NodeRecordBean> nodes, List<LinkRecordBean> links) throws SubnetDataNotFoundException {
        TopologyRecord newTopo;
        SubnetRecord currSubnet = this.getSubnetWithException(subnetName);
        TopologyRecord currTopo = currSubnet.getTopology();
        currTopo = currTopo == null ? (newTopo = this.createTopology(currSubnet, nodes, links)) : (newTopo = this.createTopologyIfNeeded(currSubnet, nodes, links));
        return currTopo;
    }

    @Override
    public TopologyRecord copyTopology(SubnetRecord subnet, Set<TopologyNodeRecord> newNodes, Set<TopologyNodeRecord> updNodes, Set<TopologyLinkRecord> newLinks, Set<TopologyLinkRecord> updLinks) {
        TopologyRecord topology = subnet.getTopology();
        for (TopologyNodeRecord newNode : newNodes) {
            Iterator<TopologyLinkRecord> nodeRec = newNode.getNode();
            NodeRecordBean bean = ((NodeRecord)((Object)nodeRec)).getNode();
            ((NodeRecord)((Object)nodeRec)).setType(this.getNodeTypeReference(bean));
        }
        Set<TopologyNodeRecord> currNodes = topology.getNodes();
        Set<TopologyLinkRecord> currLinks = topology.getLinks();
        currNodes.size();
        currLinks.size();
        for (TopologyNodeRecord updNode : updNodes) {
            currNodes.remove(updNode);
            currNodes.add(updNode);
            switch (updNode.getNode().getNode().getNodeType()) {
                case HFI: {
                    topology.setNumCAs(topology.getNumCAs() + 1L);
                    break;
                }
                case SWITCH: {
                    topology.setNumSwitches(topology.getNumSwitches() + 1L);
                    break;
                }
                case ROUTER: {
                    topology.setNumRouters(topology.getNumRouters() + 1);
                    break;
                }
                case UNKNOWN: {
                    topology.setNumUnknown(topology.getNumUnknown() + 1);
                    break;
                }
            }
        }
        for (TopologyLinkRecord updLink : updLinks) {
            currLinks.remove(updLink);
            currLinks.add(updLink);
        }
        this.startTransaction();
        TopologyRecord newTopo = this.newTopology(topology);
        this.em.persist((Object)newTopo);
        this.updateNodeSetWithTopology(currNodes, newTopo);
        this.createNodeSet(newNodes, newTopo);
        this.createLinkSet(currLinks, newTopo);
        this.createLinkSet(newLinks, newTopo);
        subnet.setTopology(newTopo);
        this.em.merge((Object)subnet);
        this.commitTransaction();
        return newTopo;
    }

    @Override
    public List<LinkRecordBean> getLinks(String subnetName) throws SubnetDataNotFoundException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createLinkTopologyNotFoundException(subnetName);
        }
        int numNodes = (int)topology.getNumNodes();
        ArrayList<LinkRecordBean> links = new ArrayList<LinkRecordBean>(numNodes);
        Query query = this.em.createNativeQuery(SQLQUERY_LINKS_WITH_LIDS);
        query.setParameter("topologyId", (Object)topology.getId());
        List rows = query.getResultList();
        for (Object row : rows) {
            Object[] r = (Object[])row;
            LinkRecordBean link = new LinkRecordBean();
            link.setFromLID((Integer)r[0]);
            link.setFromPortIndex((Short)r[1]);
            link.setToLID((Integer)r[2]);
            link.setToPortIndex((Short)r[3]);
            link.setActive((Boolean)r[4]);
            links.add(link);
        }
        return links;
    }

    @Override
    public List<LinkRecordBean> getLinks(String subnetName, int lid) throws SubnetDataNotFoundException {
        TopologyNodeRecord sourceNode;
        long sourceGuid;
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createLinkTopologyNotFoundException(subnetName);
        }
        long topologyId = topology.getId();
        List<TopologyLinkRecord> topoLinks = this.getTopologyLinkRecords(topologyId, sourceGuid = (sourceNode = this.getTopologyNodeRecordWithException(topologyId, lid)).getId().getTopologyNode());
        if (topoLinks == null) {
            throw this.createLinkTopologyNotFoundException(subnetName);
        }
        ArrayList<LinkRecordBean> res = new ArrayList<LinkRecordBean>(topoLinks.size());
        for (TopologyLinkRecord topoLink : topoLinks) {
            long targetGuid = topoLink.getId().getTargetNode();
            TopologyNodeRecord targetNode = this.getTopologyNodeRecord(topologyId, targetGuid);
            int targetLid = targetNode.getLid();
            LinkRecordBean link = new LinkRecordBean();
            link.setActive(topoLink.isActive());
            link.setFromLID(lid);
            link.setFromPortIndex(topoLink.getId().getSourcePort());
            link.setToLID(targetLid);
            link.setToPortIndex(topoLink.getId().getTargetPort());
            res.add(link);
        }
        return res;
    }

    @Override
    public TopologyRecord getTopology(String subnetName) throws SubnetDataNotFoundException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createDataNotFoundException(STLMessages.STL30025_TOPOLOGY_NOT_FOUND, subnetName);
        }
        return topology;
    }

    @Override
    public LinkRecordBean getLinkBySource(String subnetName, int lid, short portNum) throws FMException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createLinkTopologyNotFoundException(subnetName);
        }
        long topologyId = topology.getId();
        TopologyNodeRecord sourceNode = this.getTopologyNodeRecordWithException(topologyId, lid);
        long sourceGuid = sourceNode.getId().getTopologyNode();
        List<TopologyLinkRecord> topoLinks = this.getTopologyLinkRecord(topologyId, sourceGuid, portNum);
        TopologyLinkRecord topoLink = topoLinks.get(0);
        long targetGuid = topoLink.getId().getTargetNode();
        TopologyNodeRecord targetNode = this.getTopologyNodeRecord(topologyId, targetGuid);
        int targetLid = targetNode.getLid();
        LinkRecordBean link = new LinkRecordBean();
        link.setActive(topoLink.isActive());
        link.setFromLID(lid);
        link.setFromPortIndex(portNum);
        link.setToLID(targetLid);
        link.setToPortIndex(topoLink.getId().getTargetPort());
        return link;
    }

    @Override
    public LinkRecordBean getLinkByDestination(String subnetName, int lid, short portNum) throws FMException {
        SubnetRecord subnet = this.getSubnetWithException(subnetName);
        TopologyRecord topology = subnet.getTopology();
        if (topology == null) {
            throw this.createLinkTopologyNotFoundException(subnetName);
        }
        long topologyId = topology.getId();
        TopologyNodeRecord targetNode = this.getTopologyNodeRecordWithException(topologyId, lid);
        long targetGuid = targetNode.getId().getTopologyNode();
        List<TopologyLinkRecord> topoLinks = this.getTopologyLinkRecord(topologyId, targetGuid, portNum);
        TopologyLinkRecord topoLink = topoLinks.get(0);
        long sourceGuid = topoLink.getId().getTargetNode();
        TopologyNodeRecord sourceNode = this.getTopologyNodeRecord(topologyId, sourceGuid);
        int sourceLid = sourceNode.getLid();
        LinkRecordBean link = new LinkRecordBean();
        link.setActive(topoLink.isActive());
        link.setFromLID(sourceLid);
        link.setFromPortIndex(topoLink.getId().getTargetPort());
        link.setToLID(lid);
        link.setToPortIndex(portNum);
        return link;
    }

    @Override
    public TopologyNodeRecord getTopologyNodeRecord(long topologyId, int lid) {
        TypedQuery query = this.em.createNamedQuery("Node.findByLid", TopologyNodeRecord.class);
        query.setParameter("topologyId", (Object)topologyId);
        query.setParameter("lid", (Object)lid);
        List records = query.getResultList();
        if (records == null || records.size() == 0) {
            return null;
        }
        return (TopologyNodeRecord)records.get(0);
    }

    @Override
    public List<TopologyLinkRecord> getTopologyLinkRecords(long topologyId, long guid) {
        TypedQuery query = this.em.createNamedQuery("Link.findByGuid", TopologyLinkRecord.class);
        query.setParameter("topologyId", (Object)topologyId);
        query.setParameter("guid", (Object)guid);
        List records = query.getResultList();
        if (records == null || records.size() == 0) {
            return null;
        }
        return records;
    }

    private SubnetRecord getSubnetWithException(String subnetName) throws SubnetDataNotFoundException {
        SubnetRecord currSubnet = this.getSubnet(subnetName);
        if (currSubnet == null) {
            throw this.createDataNotFoundException(STLMessages.STL30022_SUBNET_NOT_FOUND, subnetName);
        }
        return currSubnet;
    }

    private TopologyRecord createTopology(SubnetRecord subnet, List<NodeRecordBean> nodes, List<LinkRecordBean> links) {
        TopologyRecord topology = this.newTopology(null);
        int size = nodes.size();
        HashMap<Integer, Long> lidMap = new HashMap<Integer, Long>(size);
        this.startTransaction();
        this.em.persist((Object)topology);
        this.persistNodes(nodes, topology, lidMap);
        this.persistLinks(links, topology, lidMap);
        this.em.merge((Object)topology);
        subnet.setTopology(topology);
        this.em.merge((Object)subnet);
        this.commitTransaction();
        return topology;
    }

    private void persistNodes(List<NodeRecordBean> nodes, TopologyRecord topology, Map<Integer, Long> lidMap) {
        long updates = 0L;
        long numNodes = 0L;
        EnumMap<NodeType, Long> nodesTypeDist = new EnumMap<NodeType, Long>(NodeType.class);
        Iterator<NodeRecordBean> it = nodes.iterator();
        while (it.hasNext()) {
            Long count;
            NodeType type;
            TopologyNodeRecord topoNode = new TopologyNodeRecord();
            topoNode.setTopology(topology);
            NodeRecordBean node = it.next();
            long nodeGUID = node.getNodeInfo().getNodeGUID();
            int lid = node.getLid();
            NodeRecord dbNode = (NodeRecord)this.em.find(NodeRecord.class, (Object)nodeGUID);
            if (dbNode == null) {
                NodeRecord nodeRec = new NodeRecord(node);
                nodeRec.setType(this.getNodeTypeReference(node));
                this.em.persist((Object)nodeRec);
                topoNode.setNode(nodeRec);
                ++updates;
            } else {
                topoNode.setNode(dbNode);
            }
            if (lidMap.containsKey(lid)) {
                DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30017_NODE_WITH_DUPLICATE_LID, nodeGUID, lid);
                log.error(dbe.getMessage());
                log.error(node.toString());
                throw dbe;
            }
            lidMap.put(lid, nodeGUID);
            topoNode.setLid(lid);
            this.em.persist((Object)topoNode);
            if (++updates >= (long)BATCH_SIZE) {
                this.flush();
                updates = 0L;
            }
            nodesTypeDist.put(type, (count = (Long)nodesTypeDist.get((Object)(type = node.getNodeType()))) == null ? 1L : count + 1L);
            ++numNodes;
        }
        if (updates >= 0L) {
            this.flush();
        }
        topology.setNumNodes(numNodes);
        Long numCAs = (Long)nodesTypeDist.get((Object)NodeType.HFI);
        topology.setNumCAs(numCAs == null ? 0L : numCAs);
        Long numSwitches = (Long)nodesTypeDist.get((Object)NodeType.SWITCH);
        topology.setNumSwitches(numSwitches == null ? 0L : numSwitches);
        Long numRouters = (Long)nodesTypeDist.get((Object)NodeType.ROUTER);
        topology.setNumRouters(numRouters == null ? 0 : numRouters.intValue());
        Long numUnknown = (Long)nodesTypeDist.get((Object)NodeType.UNKNOWN);
        topology.setNumUnknown(numUnknown == null ? 0 : numUnknown.intValue());
    }

    private void persistLinks(List<LinkRecordBean> links, TopologyRecord topology, Map<Integer, Long> lidMap) {
        long updates = 0L;
        Iterator<LinkRecordBean> it = links.iterator();
        long topologyId = topology.getId();
        while (it.hasNext()) {
            LinkRecordBean link = it.next();
            int fromLid = link.getFromLID();
            int toLid = link.getToLID();
            TopologyLinkRecord topoLink = new TopologyLinkRecord(link);
            Long fromNode = this.getNodeGUIDByLid(fromLid, lidMap);
            Long toNode = this.getNodeGUIDByLid(toLid, lidMap);
            TopologyLinkId topoLinkId = topoLink.getId();
            topoLinkId.setLinkTopology(topologyId);
            topoLinkId.setSourceNode(fromNode);
            topoLinkId.setTargetNode(toNode);
            this.em.persist((Object)topoLink);
            if (++updates < (long)BATCH_SIZE) continue;
            this.flush();
            updates = 0L;
        }
        if (updates > 0L) {
            this.flush();
        }
    }

    private TopologyRecord createTopologyIfNeeded(SubnetRecord subnet, List<NodeRecordBean> nodes, List<LinkRecordBean> links) {
        boolean noLinkChanges;
        boolean noNodeChanges;
        int size = nodes.size();
        TopologyRecord currTopology = subnet.getTopology();
        HashMap<Integer, Long> lidMap = new HashMap<Integer, Long>(size);
        Set<TopologyNodeRecord> newNodes = this.getNodeSet(currTopology, nodes, lidMap);
        Set<TopologyLinkRecord> newLinks = this.getLinkSet(currTopology, links, lidMap);
        Set<TopologyNodeRecord> currNodes = currTopology.getNodes();
        Set<TopologyLinkRecord> currLinks = currTopology.getLinks();
        HashSet<NodeRecord> updNodes = new HashSet<NodeRecord>();
        boolean nodesNeedDeletion = this.retainExistingNodes(currNodes, newNodes, updNodes);
        boolean someNodesInTopology = newNodes.removeAll(currNodes);
        boolean bl = noNodeChanges = !nodesNeedDeletion && someNodesInTopology && newNodes.size() == 0;
        if (currLinks.size() == 0 && newLinks.size() == 0) {
            noLinkChanges = true;
        } else {
            boolean linksNeedDeletion = currLinks.retainAll(newLinks);
            boolean someLinksInTopology = newLinks.removeAll(currLinks);
            noLinkChanges = !linksNeedDeletion && someLinksInTopology && newLinks.size() == 0;
        }
        this.startTransaction();
        if (updNodes.size() > 0) {
            for (NodeRecord node : updNodes) {
                this.em.merge((Object)node);
            }
        }
        if (noNodeChanges && noLinkChanges) {
            this.updateNodeSet(currNodes);
        } else {
            TopologyRecord newTopo = this.newTopology(currTopology);
            this.em.persist((Object)newTopo);
            this.updateNodeSetWithTopology(currNodes, newTopo);
            this.createNodeSet(newNodes, newTopo);
            this.createLinkSet(currLinks, newTopo);
            this.createLinkSet(newLinks, newTopo);
            subnet.setTopology(newTopo);
            this.em.merge((Object)subnet);
            currTopology = newTopo;
        }
        this.commitTransaction();
        return currTopology;
    }

    private Set<TopologyNodeRecord> getNodeSet(TopologyRecord topology, List<NodeRecordBean> nodes, Map<Integer, Long> lidMap) {
        int size = nodes.size();
        HashSet<TopologyNodeRecord> set = new HashSet<TopologyNodeRecord>(size);
        long numNodes = 0L;
        long numCAs = 0L;
        long numSwitches = 0L;
        int numRouters = 0;
        int numUnknown = 0;
        for (NodeRecordBean node : nodes) {
            int lid = node.getLid();
            long nodeGUID = node.getNodeInfo().getNodeGUID();
            TopologyNodeRecord topoNode = new TopologyNodeRecord();
            NodeRecord nodeRec = new NodeRecord(node);
            nodeRec.setType(this.getNodeTypeReference(node));
            topoNode.setTopology(topology);
            topoNode.setNode(nodeRec);
            topoNode.setLid(lid);
            set.add(topoNode);
            lidMap.put(new Integer(lid), new Long(nodeGUID));
            switch (node.getNodeType()) {
                case HFI: {
                    ++numCAs;
                    break;
                }
                case SWITCH: {
                    ++numSwitches;
                    break;
                }
                case ROUTER: {
                    ++numRouters;
                    break;
                }
                case UNKNOWN: {
                    ++numUnknown;
                    break;
                }
            }
            ++numNodes;
        }
        topology.setNumNodes(numNodes);
        topology.setNumCAs(numCAs);
        topology.setNumSwitches(numSwitches);
        topology.setNumRouters(numRouters);
        topology.setNumUnknown(numUnknown);
        return set;
    }

    private Set<TopologyLinkRecord> getLinkSet(TopologyRecord topology, List<LinkRecordBean> links, Map<Integer, Long> lidMap) {
        int size = links.size();
        HashSet<TopologyLinkRecord> set = new HashSet<TopologyLinkRecord>(size);
        for (LinkRecordBean link : links) {
            int fromLid = link.getFromLID();
            int toLid = link.getToLID();
            TopologyLinkRecord topoLink = new TopologyLinkRecord(link);
            topoLink.setTopology(topology);
            Long fromNode = this.getNodeGUIDByLid(fromLid, lidMap);
            Long toNode = this.getNodeGUIDByLid(toLid, lidMap);
            TopologyLinkId id = topoLink.getId();
            id.setSourceNode(fromNode);
            id.setTargetNode(toNode);
            set.add(topoLink);
        }
        return set;
    }

    private long getNodeGUIDByLid(int lid, Map<Integer, Long> lidMap) {
        Integer targetLid = new Integer(lid);
        Long nodeGUID = lidMap.get(targetLid);
        if (nodeGUID == null) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30018_NODE_NOT_FOUND_WITH_LID, lid);
            throw dbe;
        }
        return nodeGUID;
    }

    private boolean retainExistingNodes(Set<TopologyNodeRecord> currNodes, Set<TopologyNodeRecord> newNodes, Set<NodeRecord> updNodes) {
        boolean nodesRemoved = false;
        Iterator<TopologyNodeRecord> currit = currNodes.iterator();
        while (currit.hasNext()) {
            TopologyNodeRecord topoNode = currit.next();
            Iterator<TopologyNodeRecord> newit = newNodes.iterator();
            boolean found = false;
            while (newit.hasNext()) {
                TopologyNodeRecord newNode = newit.next();
                if (!topoNode.equals(newNode)) continue;
                if (this.nodeDescNeedsUpdate(topoNode, newNode)) {
                    NodeRecord updNode = topoNode.getNode();
                    updNode.getNode().setNodeDesc(newNode.getNode().getNode().getNodeDesc());
                    updNodes.add(updNode);
                }
                if (topoNode.getLid() != newNode.getLid()) {
                    topoNode.setLid(newNode.getLid());
                    topoNode.setLidChanged(true);
                    topoNode.setActive(newNode.isActive());
                }
                found = true;
                break;
            }
            if (found) continue;
            currit.remove();
            nodesRemoved = true;
        }
        return nodesRemoved;
    }

    private boolean nodeDescNeedsUpdate(TopologyNodeRecord currNode, TopologyNodeRecord newNode) {
        NodeRecordBean currBean = currNode.getNode().getNode();
        NodeRecordBean newBean = newNode.getNode().getNode();
        return !currBean.getNodeDesc().equals(newBean.getNodeDesc());
    }

    private void updateNodeSet(Set<TopologyNodeRecord> nodes) {
        log.debug("updateNodeSet - num nodes: " + nodes.size());
        long updates = 0L;
        for (TopologyNodeRecord topoNode : nodes) {
            if (!topoNode.isLidChanged()) continue;
            this.em.merge((Object)topoNode);
            if (++updates < (long)BATCH_SIZE) continue;
            this.flush();
            updates = 0L;
        }
        if (updates > 0L) {
            this.flush();
        }
    }

    private void updateNodeSetWithTopology(Set<TopologyNodeRecord> nodes, TopologyRecord topology) {
        long newTopologyId = topology.getId();
        log.debug("updateNodeSetWithTopology - topologyId: " + topology.getId() + "; num nodes: " + nodes.size());
        long updates = 0L;
        for (TopologyNodeRecord topoNode : nodes) {
            TopologyNodeRecord newTopoNode = new TopologyNodeRecord();
            TopologyNodeId newId = newTopoNode.getId();
            newId.setTopologyId(newTopologyId);
            newId.setTopologyNode(topoNode.getId().getTopologyNode());
            newTopoNode.setId(newId);
            newTopoNode.setLid(topoNode.getLid());
            newTopoNode.setActive(topoNode.isActive());
            this.em.persist((Object)newTopoNode);
            if (++updates < (long)BATCH_SIZE) continue;
            this.flush();
            updates = 0L;
        }
        if (updates > 0L) {
            this.flush();
        }
    }

    protected void createNodeSet(Set<TopologyNodeRecord> nodes, TopologyRecord topology) {
        log.debug("Number of new nodes being created: " + nodes.size());
        long updates = 0L;
        for (TopologyNodeRecord topoNode : nodes) {
            topoNode.setTopology(topology);
            NodeRecord node = topoNode.getNode();
            NodeRecord dbNode = (NodeRecord)this.em.find(NodeRecord.class, (Object)node.getNodeGUID());
            if (dbNode != null) {
                topoNode.setNode(dbNode);
            } else {
                node.setType(this.getNodeTypeReference(node.getNode()));
                this.em.persist((Object)node);
            }
            this.em.persist((Object)topoNode);
            if (++updates < (long)BATCH_SIZE) continue;
            this.flush();
            updates = 0L;
        }
        if (updates > 0L) {
            this.flush();
        }
    }

    protected void createNode(TopologyNodeRecord newNode, TopologyRecord topology) {
        log.debug("New node with LID = " + newNode.getLid() + " being created: ");
        newNode.setTopology(topology);
        NodeRecord node = newNode.getNode();
        NodeRecord dbNode = (NodeRecord)this.em.find(NodeRecord.class, (Object)node.getNodeGUID());
        if (dbNode != null) {
            newNode.setNode(dbNode);
        } else {
            node.setType(this.getNodeTypeReference(node.getNode()));
            this.em.persist((Object)node);
        }
        this.em.persist((Object)newNode);
    }

    protected void createLinkSet(Set<TopologyLinkRecord> links, TopologyRecord topology) {
        long topologyId = topology.getId();
        log.debug("createLinkSet - topologyId: " + topologyId + "; num nodes: " + links.size());
        long updates = 0L;
        for (TopologyLinkRecord topoLink : links) {
            TopologyLinkId linkId = topoLink.getId();
            NodeRecord fromNode = (NodeRecord)this.em.getReference(NodeRecord.class, (Object)linkId.getSourceNode());
            NodeRecord toNode = (NodeRecord)this.em.getReference(NodeRecord.class, (Object)linkId.getTargetNode());
            TopologyLinkRecord tlr = new TopologyLinkRecord();
            tlr.setTopology(topology);
            tlr.setFromNode(fromNode);
            tlr.setFromPort(linkId.getSourcePort());
            tlr.setToNode(toNode);
            tlr.setToPort(topoLink.getToPort());
            this.em.persist((Object)tlr);
            if (++updates < (long)BATCH_SIZE) continue;
            this.flush();
            updates = 0L;
        }
        if (updates > 0L) {
            this.flush();
        }
    }

    private TopologyRecord newTopology(TopologyRecord oldTopology) {
        TopologyRecord newTopology = new TopologyRecord();
        Date now = new Date();
        newTopology.setId(now.getTime());
        if (oldTopology != null) {
            newTopology.setNumNodes(oldTopology.getNumNodes());
            newTopology.setNumCAs(oldTopology.getNumCAs());
            newTopology.setNumRouters(oldTopology.getNumRouters());
            newTopology.setNumSwitches(oldTopology.getNumSwitches());
            newTopology.setNumUnknown(oldTopology.getNumUnknown());
        }
        return newTopology;
    }

    private TopologyNodeRecord getTopologyNodeRecordWithException(long topologyId, int lid) throws SubnetDataNotFoundException {
        TopologyNodeRecord topoNode = this.getTopologyNodeRecord(topologyId, lid);
        if (topoNode == null) {
            throw this.createLidNotFoundException(lid);
        }
        return topoNode;
    }

    private TopologyNodeRecord getTopologyNodeRecord(long topologyId, long guid) throws SubnetDataNotFoundException {
        TypedQuery query = this.em.createNamedQuery("Node.findByGuid", TopologyNodeRecord.class);
        query.setParameter("topologyId", (Object)topologyId);
        query.setParameter("guid", (Object)guid);
        List records = query.getResultList();
        if (records == null || records.size() == 0) {
            throw this.createNodeNotFoundException("TopologyNodeRecord", topologyId + "/" + StringUtils.longHexString(guid));
        }
        return (TopologyNodeRecord)records.get(0);
    }

    private List<TopologyLinkRecord> getTopologyLinkRecord(long topologyId, long guid, int port) throws SubnetDataNotFoundException {
        TypedQuery query = this.em.createNamedQuery("Link.findByGuidPort", TopologyLinkRecord.class);
        query.setParameter("topologyId", (Object)topologyId);
        query.setParameter("guid", (Object)guid);
        query.setParameter("port", (Object)((short)port));
        List records = query.getResultList();
        if (records == null || records.size() == 0) {
            throw this.createLinkNotFoundException(topologyId + "/" + StringUtils.longHexString(guid) + "/" + port);
        }
        return records;
    }

    private SubnetRecord getSubnet(String subnetName, String prefix) {
        TypedQuery query = this.em.createNamedQuery("Subnet.findByName", SubnetRecord.class);
        String uniqueName = prefix + subnetName;
        query.setParameter("subnetName", (Object)uniqueName);
        List records = query.getResultList();
        if (records == null || records.size() == 0) {
            return null;
        }
        return (SubnetRecord)records.get(0);
    }

    private DatabaseException createPersistException(Throwable cause, Class<?> targetClass, Object entityId) throws DatabaseException {
        DatabaseException dbe = DatabaseUtils.createPersistDatabaseException(cause, targetClass, entityId);
        log.error(dbe.getMessage(), cause);
        return dbe;
    }

    private NodeTypeRecord getNodeTypeReference(NodeRecordBean nodeBean) {
        NodeType nodeType = nodeBean.getNodeType();
        if (nodeType == null) {
            throw new RuntimeException("Invalid NodeRecordBean: " + nodeBean);
        }
        return (NodeTypeRecord)this.em.getReference(NodeTypeRecord.class, (Object)nodeType.getId());
    }

    private SubnetDataNotFoundException createNodeNotFoundException(Object ... arguments) {
        return this.createDataNotFoundException(STLMessages.STL30023_NODE_NOT_FOUND, arguments);
    }

    private SubnetDataNotFoundException createLidNotFoundException(Object ... arguments) {
        return this.createDataNotFoundException(STLMessages.STL30031_NODE_NOT_FOUND_LID, arguments);
    }

    private SubnetDataNotFoundException createPortGuidNotFoundException(Object ... arguments) {
        return this.createDataNotFoundException(STLMessages.STL30033_NODE_NOT_FOUND_PORT_GUID, arguments);
    }

    private SubnetDataNotFoundException createLinkNotFoundException(Object ... arguments) {
        return this.createDataNotFoundException(STLMessages.STL30024_LINK_NOT_FOUND, arguments);
    }

    private SubnetDataNotFoundException createNodeTopologyNotFoundException(Object ... arguments) {
        return this.createDataNotFoundException(STLMessages.STL30032_NODE_NOT_FOUND_TNF, arguments);
    }

    private SubnetDataNotFoundException createLinkTopologyNotFoundException(Object ... arguments) {
        return this.createDataNotFoundException(STLMessages.STL30030_LINK_NOT_FOUND_TNF, arguments);
    }

    private SubnetDataNotFoundException createDataNotFoundException(STLMessages msg, Object ... arguments) {
        SubnetDataNotFoundException dnf = new SubnetDataNotFoundException((IMessage)msg, arguments);
        return dnf;
    }
}

