/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import com.intel.stl.api.MadException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.notice.IEventListener;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.common.STLMessages;
import com.intel.stl.fecdriver.ICommand;
import com.intel.stl.fecdriver.dispatcher.Handler;
import com.intel.stl.fecdriver.dispatcher.IConnection;
import com.intel.stl.fecdriver.dispatcher.IConnectionEventListener;
import com.intel.stl.fecdriver.dispatcher.IRequestDispatcher;
import com.intel.stl.fecdriver.messages.adapter.CommonMad;
import com.intel.stl.fecdriver.messages.adapter.NetHeader;
import com.intel.stl.fecdriver.messages.adapter.NetPacket;
import com.intel.stl.fecdriver.messages.adapter.OobPacket;
import com.intel.stl.fecdriver.messages.adapter.RmppMad;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import com.intel.stl.fecdriver.messages.response.sa.FVRspNotice;
import com.intel.stl.fecdriver.session.RequestCancelledByUserException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends Handler<Void>
implements IConnection {
    private static final int DEFAULT_IN_BUFFER_SIZE = 16921;
    protected static int CONN_TIMEOUT = 30000;
    protected static Logger log = LoggerFactory.getLogger(Connection.class);
    private final NetHeader netHeader;
    private ByteBuffer inBuffer;
    private ByteBuffer[] outBuffers = null;
    private Thread connectionTimeoutThread = null;
    protected long outRemaining;
    private int inRemaining;
    protected int interestOps;
    private boolean isTemporaryConnection = false;
    protected boolean connected = false;
    protected boolean initialHandshake = false;
    protected boolean closing = false;
    protected boolean processing = false;
    protected SelectionKey selectionKey;
    private final List<IEventListener<NoticeBean>> noticeListeners = new CopyOnWriteArrayList<IEventListener<NoticeBean>>();
    private final ConcurrentLinkedQueue<OobPacket> pendingPackets = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<Long, ICommand<?, ?>> pendingCmds = new ConcurrentHashMap();
    protected final IConnectionEventListener listener;
    protected final SocketChannel channel;
    protected final HostInfo hostInfo;

    public Connection(HostInfo hostInfo, SocketChannel channel, IConnectionEventListener listener) {
        this.hostInfo = hostInfo;
        this.channel = channel;
        this.listener = listener;
        this.netHeader = new NetHeader();
        this.netHeader.build(true);
        this.inBuffer = ByteBuffer.allocate(16921);
        this.inBuffer.limit(0);
        this.inRemaining = 0;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        if (this.connectionTimeoutThread != null) {
            this.connectionTimeoutThread.interrupt();
            this.connectionTimeoutThread = null;
        }
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public boolean isClosing() {
        return this.closing;
    }

    protected void setProcessing(boolean processing) {
        this.processing = processing;
    }

    protected boolean isProcessing() {
        return this.processing;
    }

    protected void initialize(Selector selector, IRequestDispatcher dispatcher) throws Exception {
        try {
            String host = this.hostInfo.getHost();
            int port = this.hostInfo.getPort();
            InetSocketAddress feAddress = new InetSocketAddress(host, port);
            this.channel.configureBlocking(false);
            this.selectionKey = this.channel.register(selector, 8, this);
            log.debug("Connection {} is connecting to {}", (Object)this, (Object)feAddress);
            this.channel.connect(feAddress);
            this.startConnTimeoutThread(dispatcher);
        }
        catch (Exception e) {
            log.error("Error initializing connection {}", (Object)this, (Object)e);
            this.notifyError(e);
            throw e;
        }
    }

    protected void assignCmd(ICommand<?, ?> cmd) {
        cmd.setConnectionInProgress(!this.connected);
        long id = cmd.getMessageID();
        OobPacket packet = cmd.getPacket();
        this.pendingCmds.putIfAbsent(id, cmd);
        this.pendingPackets.add(packet);
    }

    protected SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    protected Collection<ICommand<?, ?>> getPendingCommands() {
        return this.pendingCmds.values();
    }

    @Override
    protected Void handle() throws Exception {
        if (log.isDebugEnabled() && this.selectionKey.isValid()) {
            String inBufferState = this.buffer2String(this.inBuffer);
            log.debug("Handle connection {}. ReadyOps: {}; inBuffer: {}; outRemaining: {}", new Object[]{this, this.selectionKey.readyOps(), inBufferState, this.outRemaining});
        }
        if (this.selectionKey.isValid() && this.selectionKey.isConnectable()) {
            try {
                this.handleConnectionFinish();
            }
            catch (Exception e) {
                this.notifyError(e);
                throw e;
            }
        }
        if (this.selectionKey.isValid() && this.selectionKey.isReadable()) {
            this.processRead();
        }
        if (this.selectionKey.isValid() && this.selectionKey.isWritable()) {
            this.processWrite();
        }
        return null;
    }

    private void processRead() throws Exception {
        this.turnOpsOff(1);
        try {
            this.handleRead();
        }
        catch (Exception e) {
            this.notifyError(e);
            throw e;
        }
        finally {
            this.turnOpsOn(1);
        }
    }

    private void processWrite() throws Exception {
        try {
            this.handleWrite();
        }
        catch (Exception e) {
            this.notifyError(e);
            throw e;
        }
        finally {
            if (this.outRemaining == 0L && !this.arePacketsPending()) {
                this.turnOpsOn(1);
                this.turnOpsOff(4);
            } else {
                this.turnOpsOn(4);
            }
        }
    }

    protected void handleRead() throws IOException {
        int len;
        do {
            if (this.inRemaining > 0) {
                len = this.readBuffer(this.inBuffer);
                this.inRemaining -= len;
                log.debug("Read {}, remaining {}. ", (Object)len, (Object)this.inRemaining);
            } else {
                ByteBuffer netHeaderBuff = this.netHeader.getByteBuffer();
                if (!netHeaderBuff.hasRemaining()) {
                    netHeaderBuff.clear();
                }
                len = this.readBuffer(netHeaderBuff);
                log.debug("Read NetHeader: len = {} isValid = {}.", (Object)len, (Object)this.netHeader.isValid());
                if (netHeaderBuff.hasRemaining()) {
                    return;
                }
                if (this.netHeader.isValid()) {
                    this.inBuffer.clear();
                    this.inRemaining = this.netHeader.getMsgLength() - this.netHeader.getLength();
                    if (this.inRemaining > this.inBuffer.capacity()) {
                        this.inBuffer = ByteBuffer.allocate(this.inRemaining);
                        log.info("Increased input buffer size to {}.", (Object)this.inRemaining);
                    } else {
                        this.inBuffer.clear();
                        this.inBuffer.limit(this.inRemaining);
                    }
                    len = this.readBuffer(this.inBuffer);
                    this.inRemaining -= len;
                    log.debug("Read {}, remaining {}.", (Object)len, (Object)this.inRemaining);
                } else {
                    log.error("NetHeader is invalid: {} ", (Object)this.netHeader.toString(""));
                    this.invalidateAllCmds();
                }
            }
            if (this.inRemaining != 0) continue;
            this.processResponse();
        } while (len > 0 && this.pendingCmds.size() > 0);
    }

    protected void handleWrite() throws IOException {
        if (this.outRemaining == 0L) {
            if (this.arePacketsPending()) {
                OobPacket packet = this.getNextPacket();
                if (packet == null) {
                    log.warn("packet is null!");
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Sending request with message id '{}' ", (Object)packet.getRmppMad().getCommonMad().getTransactionId());
                }
                NetPacket netPacket = new NetPacket();
                netPacket.build(true);
                netPacket.setData(packet);
                for (ByteBuffer buffer : this.outBuffers = netPacket.getByteBuffers()) {
                    buffer.clear();
                    this.outRemaining += (long)buffer.capacity();
                }
                if (log.isTraceEnabled()) {
                    netPacket.dump("", System.out);
                }
                long len = this.writeBuffers(this.outBuffers);
                this.outRemaining -= len;
                log.debug("Write {}, remaining {}.", (Object)len, (Object)this.outRemaining);
            }
        } else {
            long len = this.writeBuffers(this.outBuffers);
            this.outRemaining -= len;
            log.debug("Write {}, remaining {}.", (Object)len, (Object)this.outRemaining);
        }
    }

    private void handleConnectionFinish() throws Exception {
        if (this.channel.isConnectionPending()) {
            boolean success = this.channel.finishConnect();
            if (success) {
                this.turnOpsOff(8);
                this.onConnectionComplete();
            } else {
                this.turnOpsOn(8);
            }
        }
    }

    protected void onConnectionComplete() throws IOException {
        this.connected = true;
        this.outRemaining = 0L;
        for (ICommand<?, ?> cmd : this.pendingCmds.values()) {
            cmd.setConnectionInProgress(false);
        }
        log.info("Connection {} is now connected to FE at {}", (Object)this, (Object)this.hostInfo.toString());
        this.stopConnTimeoutThread();
        if (this.listener != null) {
            try {
                this.listener.onConnectionComplete(this);
            }
            catch (Exception e) {
                log.error("Connection event listener had an exception", (Throwable)e);
            }
        }
        if (this.arePacketsPending()) {
            try {
                this.processWrite();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    RuntimeException rte = (RuntimeException)e;
                    throw rte;
                }
                e.printStackTrace();
            }
        }
    }

    protected void notifyError(Exception exception) {
        if (this.listener != null) {
            try {
                this.listener.onConnectionError(this, exception);
            }
            catch (Exception e) {
                log.error("Connection event listener had an exception", (Throwable)e);
            }
        }
    }

    protected int getInterestOps() {
        return this.interestOps;
    }

    protected void setInterestOps(int ops) {
        this.interestOps = ops;
    }

    protected void turnOpsOn(int opsOn) {
        this.interestOps |= opsOn;
    }

    protected void turnOpsOff(int opsOff) {
        this.interestOps &= ~opsOff;
    }

    protected boolean arePacketsPending() {
        return !this.pendingPackets.isEmpty();
    }

    protected boolean areRepliesPending() {
        return !this.pendingCmds.isEmpty();
    }

    protected OobPacket getNextPacket() {
        OobPacket packet = null;
        while (!this.pendingPackets.isEmpty()) {
            packet = this.pendingPackets.poll();
            long msgId = packet.getRmppMad().getCommonMad().getTransactionId();
            if (packet.getExpireTime() > System.currentTimeMillis() && this.pendingCmds.containsKey(msgId)) break;
            log.info("Ignore packet id={} expire={} {}", new Object[]{msgId, packet.getExpireTime(), this.pendingCmds.containsKey(msgId)});
        }
        return packet;
    }

    protected void processResponse() throws IOException {
        int limit = this.inBuffer.limit();
        if (limit == 0) {
            return;
        }
        byte[] bytes = this.inBuffer.array();
        OobPacket packet = new OobPacket();
        int offset = this.inBuffer.arrayOffset();
        int pos = packet.wrap(bytes, offset);
        RmppMad mad = new RmppMad();
        pos = mad.wrap(bytes, pos);
        int remainingBytes = offset + limit - pos;
        CommonMad comMad = mad.getCommonMad();
        long transId = comMad.getTransactionId();
        short attrId = comMad.getAttributeID();
        if (attrId == 2) {
            byte[] noticeBytes = Arrays.copyOfRange(bytes, pos, pos + remainingBytes);
            this.setRmppData(mad, noticeBytes, 0, remainingBytes);
            FVRspNotice response = new FVRspNotice();
            response.processMad(mad);
            this.fireNotice(response.get().toArray(new NoticeBean[0]));
        } else {
            this.setRmppData(mad, bytes, pos, remainingBytes);
            ICommand<?, ?> cmd = this.pendingCmds.remove(transId);
            if (cmd != null && cmd.getResponse() != null) {
                Object response = cmd.getResponse();
                short status = comMad.getNSStatus();
                if (status != 0) {
                    if (status == 256) {
                        String emsg = STLMessages.STL20004_SM_UNAVAILABLE.getDescription();
                        ClosedChannelException cce = this.processSMUnavailable(cmd, transId, emsg);
                        throw cce;
                    }
                    if (status == 2560) {
                        String emsg = STLMessages.STL20005_PM_UNAVAILABLE.getDescription();
                        ClosedChannelException cce = this.processSMUnavailable(cmd, transId, emsg);
                        throw cce;
                    }
                    MadException madException = new MadException(response.getClass(), attrId, status, response.getDescription());
                    response.setError(madException);
                    log.error(madException.getMessage());
                } else {
                    log.debug("Replying to request with message id '{}'", (Object)transId);
                    response.processMad(mad);
                    Exception error = response.getError();
                    if (error != null) {
                        if (error instanceof RequestCancelledByUserException) {
                            log.warn("Response {} for message id '{}' cancelled by user", (Object)response.getClass().getSimpleName(), (Object)transId);
                        } else {
                            log.error("Failed processing data for response {} with message id '{}'", new Object[]{response.getClass().getSimpleName(), transId, error});
                        }
                    }
                }
            } else {
                log.error("No response found for mad associated with message id '{}'; AttributeID={}", (Object)transId, (Object)StringUtils.shortHexString(attrId));
            }
        }
    }

    private ClosedChannelException processSMUnavailable(ICommand<?, ?> cmd, long transId, String emsg) {
        ClosedChannelException cce = new ClosedChannelException();
        IOException ioe = new IOException(emsg);
        cce.initCause(ioe);
        Object response = cmd.getResponse();
        if (this.isTemporaryConnection) {
            response.setError(ioe);
        } else {
            this.pendingCmds.put(transId, cmd);
        }
        log.debug(emsg, (Throwable)cce);
        return cce;
    }

    protected boolean isTemporaryConnection() {
        return this.isTemporaryConnection;
    }

    protected void setTemporaryConnection(boolean isTemporaryConnection) {
        this.isTemporaryConnection = isTemporaryConnection;
    }

    protected int readBuffer(ByteBuffer appBuffer) throws IOException {
        int len;
        int read = len = this.read(appBuffer);
        while (len > 0 && appBuffer.hasRemaining()) {
            len = this.read(appBuffer);
            read += len;
        }
        return read;
    }

    private int read(ByteBuffer appBuffer) throws IOException {
        int len = this.channel.read(appBuffer);
        if (log.isDebugEnabled()) {
            String appBufferState = this.buffer2String(appBuffer);
            log.debug("Read {} bytes from socket. appBuffer: {}", (Object)len, (Object)appBufferState);
        }
        if (len == -1) {
            ClosedChannelException cce = new ClosedChannelException();
            String emsg = STLMessages.STL20006_CHANNEL_CLOSED.getDescription();
            IOException ioe = new IOException(emsg);
            cce.initCause(ioe);
            throw cce;
        }
        return len;
    }

    private void setRmppData(RmppMad mad, byte[] bytes, int pos, int size) {
        SimpleDatagram data = new SimpleDatagram(size);
        data.wrap(bytes, pos);
        mad.setData(data);
        if (log.isTraceEnabled()) {
            String formatted = mad.toString(Thread.currentThread().getName() + " ");
            log.trace(formatted);
        }
    }

    protected long writeBuffers(ByteBuffer[] appBuffers) throws IOException {
        return this.channel.write(appBuffers);
    }

    protected void addNoticeListener(IEventListener<NoticeBean> listener) {
        this.noticeListeners.add(listener);
    }

    protected void removeNoticeListener(IEventListener<NoticeBean> listener) {
        this.noticeListeners.add(listener);
    }

    protected void fireNotice(NoticeBean[] notices) {
        log.info("Fire {} notices: {}", (Object)notices.length, (Object)Arrays.toString(notices));
        for (IEventListener<NoticeBean> listener : this.noticeListeners) {
            try {
                listener.onNewEvent((NoticeBean[])notices);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void invalidateAllCmds() throws IOException {
        IOException ioe = new IOException("Illegal Data");
        for (ICommand<?, ?> cmd : this.pendingCmds.values()) {
            Object resp = cmd.getResponse();
            resp.setError(ioe);
        }
        throw ioe;
    }

    private void startConnTimeoutThread(final IRequestDispatcher dispatcher) {
        if (this.connectionTimeoutThread == null) {
            this.connectionTimeoutThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(CONN_TIMEOUT);
                        String hostName = Connection.this.hostInfo.getHost();
                        log.info("Timeout attempting to connect to host {}:{}", (Object)hostName, (Object)Connection.this.hostInfo.getPort());
                        TimeoutException toe = new TimeoutException(STLMessages.STL20003_CONNECTION_TIMEOUT.getDescription(hostName));
                        dispatcher.onRequestTimeout(toe);
                        Connection.this.notifyError(toe);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            String connName = this.toString();
            int x = connName.indexOf("@");
            connName = connName.substring(x + 1);
            this.connectionTimeoutThread.setName(this.hostInfo.getHost() + "-" + connName + "-conntimeout");
            this.connectionTimeoutThread.start();
        }
    }

    private void stopConnTimeoutThread() {
        if (this.connectionTimeoutThread != null) {
            this.connectionTimeoutThread.interrupt();
            this.connectionTimeoutThread = null;
        }
    }

    protected String buffer2String(ByteBuffer buffer) {
        String buffState = "[pos=" + buffer.position() + " lim=" + buffer.limit() + " cap=" + buffer.capacity() + "]";
        return buffState;
    }

    protected SocketChannel getSocketChannel() {
        return this.channel;
    }

    protected void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    protected ConcurrentHashMap<Long, ICommand<?, ?>> getPendingCmds() {
        return this.pendingCmds;
    }
}

