/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import com.intel.stl.fecdriver.dispatcher.Handler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class Reactor<H extends Handler<R>, R>
extends Thread {
    protected static Logger log = LoggerFactory.getLogger(Reactor.class);
    private static final long SHUTDOWN_TIMEOUT = 1000L;
    private boolean shutdown = false;
    private final ExecutorService threadPool;

    public Reactor(ExecutorService service) {
        this.threadPool = service;
    }

    protected void dispatch(H handler) {
        if (this.shutdown) {
            return;
        }
        ((Handler)handler).setLoggingContextMap(MDC.getCopyOfContextMap());
        HandlerTask task = this.createHandlerTask(handler);
        this.threadPool.execute(task);
    }

    protected HandlerTask createHandlerTask(H handler) {
        return new HandlerTask(this, handler);
    }

    protected void shutdown() {
        this.shutdown = true;
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            if (!this.threadPool.isTerminated()) {
                this.threadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected abstract void onHandlerDone(HandlerTask var1);

    protected static class HandlerTask
    extends FutureTask<R> {
        private final H callable;
        final /* synthetic */ Reactor this$0;

        protected HandlerTask(H callable) {
            this.this$0 = this$0;
            super(callable);
            this.callable = callable;
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
            log.error("Exception occurred in handler {}", this.callable, (Object)t);
        }

        @Override
        protected void done() {
            this.this$0.onHandlerDone(this);
        }

        protected H getCallable() {
            return this.callable;
        }
    }
}

