/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter;

import com.intel.stl.fecdriver.messages.adapter.IDatagram;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class ComposedDatagram<E>
implements IDatagram<E> {
    private int length = 0;
    private List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private ByteOrder order = null;
    private boolean hasConsistentOrder = true;
    private List<IDatagram<?>> datagrams = new ArrayList();
    private boolean dirty = true;

    public ComposedDatagram() {
    }

    public ComposedDatagram(IDatagram<?> ... datagrams) {
        for (IDatagram<?> datagram : datagrams) {
            this.datagrams.add(datagram);
        }
    }

    @Override
    public int build(boolean force) {
        int len = 0;
        for (IDatagram<?> datagram : this.datagrams) {
            len += datagram.build(force);
        }
        if (len > 0) {
            this.refresh();
        }
        return this.getLength();
    }

    @Override
    public int wrap(byte[] data, int offset) {
        int pos = offset;
        for (IDatagram<?> datagram : this.datagrams) {
            pos = datagram.wrap(data, pos);
        }
        this.refresh();
        return pos;
    }

    public void refresh() {
        this.length = 0;
        this.buffers.clear();
        this.order = null;
        for (IDatagram<?> datagram : this.datagrams) {
            if (!datagram.hasBuffer()) {
                throw new IllegalArgumentException("Datagram has no buffer! Please initialize it with #build or #wrap method first.");
            }
            this.length += datagram.getLength();
            ByteBuffer[] localBuffers = datagram.getByteBuffers();
            if (localBuffers != null) {
                for (ByteBuffer buffer : localBuffers) {
                    this.buffers.add(buffer);
                }
            }
            if (datagram instanceof ComposedDatagram && !((ComposedDatagram)datagram).hasConsistentOrder) {
                this.hasConsistentOrder = false;
                continue;
            }
            if (this.order == null) {
                this.order = datagram.getByteOrder();
                continue;
            }
            if (!this.hasConsistentOrder || this.order == datagram.getByteOrder()) continue;
            this.hasConsistentOrder = false;
        }
        this.dirty = false;
    }

    public List<IDatagram<?>> getDatagrams() {
        return this.datagrams;
    }

    public void addDatagram(IDatagram<?> datagram) {
        if (datagram == null) {
            return;
        }
        this.datagrams.add(datagram);
        if (!datagram.hasBuffer()) {
            this.dirty = true;
            return;
        }
        this.length += datagram.getLength();
        ByteBuffer[] localBuffers = datagram.getByteBuffers();
        if (localBuffers != null) {
            for (ByteBuffer buffer : localBuffers) {
                this.buffers.add(buffer);
            }
        }
        if (datagram instanceof ComposedDatagram && !((ComposedDatagram)datagram).hasConsistentOrder) {
            this.hasConsistentOrder = false;
            return;
        }
        if (this.order == null) {
            this.order = datagram.getByteOrder();
        } else if (this.hasConsistentOrder && this.order != datagram.getByteOrder()) {
            this.hasConsistentOrder = false;
        }
    }

    public void removeDatagram(IDatagram<?> datagram) {
        if (datagram == null) {
            return;
        }
        if (!this.datagrams.remove(datagram)) {
            return;
        }
        if (!datagram.hasBuffer()) {
            this.dirty = true;
            return;
        }
        this.length -= datagram.getLength();
        ByteBuffer[] localBuffers = datagram.getByteBuffers();
        if (localBuffers != null) {
            for (ByteBuffer buffer : localBuffers) {
                this.buffers.remove(buffer);
            }
        }
        if (!this.hasConsistentOrder) {
            this.order = null;
            this.hasConsistentOrder = true;
            for (IDatagram iDatagram : this.datagrams) {
                if (datagram instanceof ComposedDatagram && !((ComposedDatagram)datagram).hasConsistentOrder) {
                    this.hasConsistentOrder = false;
                    break;
                }
                if (this.order == null) {
                    this.order = iDatagram.getByteOrder();
                    continue;
                }
                if (this.order == iDatagram.getByteOrder()) continue;
                this.hasConsistentOrder = false;
                break;
            }
        }
    }

    @Override
    public ByteBuffer[] getByteBuffers() {
        if (this.dirty) {
            this.refresh();
        }
        return this.buffers.toArray(new ByteBuffer[0]);
    }

    @Override
    public int getLength() {
        if (this.dirty) {
            this.refresh();
        }
        return this.length;
    }

    @Override
    public ByteOrder getByteOrder() {
        if (this.dirty) {
            this.refresh();
        }
        if (this.hasConsistentOrder) {
            return this.order;
        }
        throw new RuntimeException("No consistent ByteOrder");
    }

    @Override
    public boolean hasBuffer() {
        return !this.dirty;
    }

    @Override
    public void dump(String prefix, PrintStream out) {
        out.println(prefix + this.getClass().getSimpleName());
        for (IDatagram<?> datagram : this.datagrams) {
            datagram.dump(prefix + "  ", out);
        }
    }

    @Override
    public String toString(String prefix) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(prefix);
        strBuff.append(this.getClass().getSimpleName());
        for (IDatagram<?> datagram : this.datagrams) {
            strBuff.append(datagram.toString(prefix + "  "));
        }
        return strBuff.toString();
    }

    @Override
    public E toObject() {
        return null;
    }
}

