/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.pa;

import com.intel.stl.api.performance.CategoryBucketBean;
import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.api.performance.CategorySummaryBean;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.api.performance.VFInfoBean;
import com.intel.stl.common.StringUtils;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import java.util.ArrayList;

public class VFInfo
extends SimpleDatagram<VFInfoBean> {
    public VFInfo() {
        super(346);
    }

    public void setVfName(String name) {
        StringUtils.setString(name, this.buffer, 0, 64);
    }

    public void setImageNumber(long num) {
        this.buffer.putLong(72, num);
    }

    public void setImageOffset(int offset) {
        this.buffer.putInt(80, offset);
    }

    private UtilStatsBean getUtilStatsBean(int position) {
        this.buffer.position(position);
        UtilStatsBean bean = new UtilStatsBean();
        bean.setTotalMBps(this.buffer.getLong());
        bean.setTotalKPps(this.buffer.getLong());
        bean.setAvgMBps(this.buffer.getInt());
        bean.setMinMBps(this.buffer.getInt());
        bean.setMaxMBps(this.buffer.getInt());
        bean.setNumBWBuckets(this.buffer.getInt());
        ArrayList<Integer> buckets = new ArrayList<Integer>(10);
        for (int i = 0; i < 10; ++i) {
            buckets.add(this.buffer.getInt());
        }
        bean.setBwBuckets(buckets);
        bean.setAvgKPps(this.buffer.getInt());
        bean.setMinKPps(this.buffer.getInt());
        bean.setMaxKPps(this.buffer.getInt());
        bean.setPmaNoRespPorts(this.buffer.getShort());
        bean.setTopoIncompPorts(this.buffer.getShort());
        return bean;
    }

    private CategoryStatBean getCategoryStatBean(int position) {
        this.buffer.position(position);
        CategorySummaryBean esBean = new CategorySummaryBean();
        esBean.setIntegrityErrors(this.buffer.getInt());
        esBean.setCongestion(this.buffer.getInt());
        esBean.setSmaCongestion(this.buffer.getInt());
        esBean.setBubble(this.buffer.getInt());
        esBean.setSecurityErrors(this.buffer.getInt());
        esBean.setRoutingErrors(this.buffer.getInt());
        esBean.setUtilizationPct10(this.buffer.getShort() & 0xFFFF);
        esBean.setDiscardsPct10(this.buffer.getShort() & 0xFFFF);
        this.buffer.getInt();
        this.buffer.getInt();
        this.buffer.getInt();
        CategoryBucketBean[] ebBeans = new CategoryBucketBean[5];
        for (int i = 0; i < ebBeans.length; ++i) {
            ebBeans[i] = new CategoryBucketBean();
            ebBeans[i].setIntegrityErrors(this.buffer.getInt());
            ebBeans[i].setCongestion(this.buffer.getInt());
            ebBeans[i].setSmaCongestion(this.buffer.getInt());
            ebBeans[i].setBubble(this.buffer.getInt());
            ebBeans[i].setSecurityErrors(this.buffer.getInt());
            ebBeans[i].setRoutingErrors(this.buffer.getInt());
        }
        CategoryStatBean bean = new CategoryStatBean(esBean, ebBeans);
        return bean;
    }

    @Override
    public VFInfoBean toObject() {
        this.buffer.clear();
        VFInfoBean bean = new VFInfoBean();
        bean.setVfName(StringUtils.toString(this.buffer.array(), this.buffer.arrayOffset(), 64));
        this.buffer.position(72);
        ImageIdBean imageId = new ImageIdBean(this.buffer.getLong(), this.buffer.getInt(), this.buffer.getInt());
        bean.setImageId(imageId);
        this.buffer.position(88);
        bean.setNumPorts(this.buffer.getInt());
        UtilStatsBean utilStat = this.getUtilStatsBean(92);
        bean.setInternalUtilStats(utilStat);
        CategoryStatBean errStatBean = this.getCategoryStatBean(180);
        bean.setInternalCategoryStats(errStatBean);
        this.buffer.position(340);
        bean.setMaxInternalRate(this.buffer.get());
        bean.setMinInternalRate(this.buffer.get());
        bean.setMaxInternalMBps(this.buffer.getInt());
        return bean;
    }
}

