/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.pa;

import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.common.StringUtils;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class VFPortCounters
extends SimpleDatagram<VFPortCountersBean> {
    private static final int VFNAME_OFFSET = 24;
    private static final int IMAGEID_OFFSET = 96;
    private static final int IMAGEOFFSET_OFFSET = 104;
    private static final int COUNTERS_OFFSET = 112;

    public VFPortCounters() {
        super(224);
    }

    public void setNodeLid(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setPortNumber(byte num) {
        this.buffer.put(4, num);
    }

    public void setFlags(int flag) {
        this.buffer.putInt(8, flag);
    }

    public void setVfName(String name) {
        StringUtils.setString(name, this.buffer, 24, 64);
    }

    public void setImageNumber(long imageNumber) {
        this.buffer.putLong(96, imageNumber);
    }

    public void setImageOffset(int imageOffset) {
        this.buffer.putInt(104, imageOffset);
    }

    @Override
    public VFPortCountersBean toObject() {
        this.buffer.clear();
        VFPortCountersBean bean = new VFPortCountersBean();
        bean.setNodeLid(this.buffer.getInt());
        bean.setPortNumber(this.buffer.get());
        this.buffer.position(8);
        bean.setFlags(this.buffer.getInt());
        bean.setVfName(StringUtils.toString(this.buffer.array(), this.buffer.arrayOffset() + 24, 64));
        this.buffer.position(96);
        bean.setImageId(new ImageIdBean(this.buffer.getLong(), this.buffer.getInt(), this.buffer.getInt()));
        this.buffer.position(112);
        bean.setPortVFXmitData(this.buffer.getLong());
        bean.setPortVFRcvData(this.buffer.getLong());
        bean.setPortVFXmitPkts(this.buffer.getLong());
        bean.setPortVFRcvPkts(this.buffer.getLong());
        bean.setPortVFXmitDiscards(this.buffer.getLong());
        bean.setSwPortVFCongestion(this.buffer.getLong());
        bean.setPortVFXmitWait(this.buffer.getLong());
        bean.setPortVFRcvFECN(this.buffer.getLong());
        bean.setPortVFRcvBECN(this.buffer.getLong());
        bean.setPortVFXmitTimeCong(this.buffer.getLong());
        bean.setPortVFXmitWastedBW(this.buffer.getLong());
        bean.setPortVFXmitWaitData(this.buffer.getLong());
        bean.setPortVFRcvBubble(this.buffer.getLong());
        bean.setPortVFMarkFECN(this.buffer.getLong());
        return bean;
    }
}

