/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class NodeInfo
extends SimpleDatagram<NodeInfoBean> {
    public NodeInfo() {
        super(44);
    }

    public void setBaseVersion(byte version) {
        this.buffer.put(0, version);
    }

    public void setClassVersion(byte version) {
        this.buffer.put(1, version);
    }

    public void setNodeType(byte type) {
        this.buffer.put(2, type);
    }

    public void setNumPorts(byte num) {
        this.buffer.put(3, num);
    }

    public void setSystemImageGUID(long guid) {
        this.buffer.putLong(8, guid);
    }

    public void setNodeGUID(long guid) {
        this.buffer.putLong(16, guid);
    }

    public void setPortGUID(long guid) {
        this.buffer.putLong(24, guid);
    }

    public void setPartitionCap(short cap) {
        this.buffer.putShort(32, cap);
    }

    public void setDeviceID(short id) {
        this.buffer.putShort(34, id);
    }

    public void setRevision(int revision) {
        this.buffer.putInt(36, revision);
    }

    public void setLocalPortNum(byte num) {
        this.buffer.put(40, num);
    }

    public void setVendorID(int num) {
        int old = this.buffer.getInt(40);
        int value = old & 0xFF000000 | num & 0xFFFFFF;
        this.buffer.putInt(40, value);
    }

    public int getVendorID() {
        int raw = this.buffer.getInt(40);
        return raw & 0xFFFFFF;
    }

    @Override
    public NodeInfoBean toObject() {
        this.buffer.clear();
        byte baseVersion = this.buffer.get();
        byte classVersion = this.buffer.get();
        byte nodeType = this.buffer.get();
        byte numPorts = this.buffer.get();
        this.buffer.position(8);
        long sysImageGUID = this.buffer.getLong();
        long nodeGUID = this.buffer.getLong();
        long portGUID = this.buffer.getLong();
        short partitionCap = this.buffer.getShort();
        short deviceID = this.buffer.getShort();
        int revision = this.buffer.getInt();
        byte localPortNum = this.buffer.get();
        int vendorID = this.getVendorID();
        return new NodeInfoBean(baseVersion, classVersion, nodeType, numPorts, sysImageGUID, nodeGUID, portGUID, partitionCap, deviceID, revision, localPortNum, vendorID);
    }
}

