/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.TraceRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class TraceRecord
extends SimpleDatagram<TraceRecordBean> {
    public static final long STL_TRACE_RECORD_COMP_ENCRYPT_MASK = 0x55555555L;

    public TraceRecord() {
        super(40);
    }

    public void setIDGeneration(short iDGeneration) {
        this.buffer.putShort(0, iDGeneration);
    }

    public void setNodeType(NodeType type) {
        this.buffer.put(3, (byte)type.ordinal());
    }

    public void setEntryPort(byte port) {
        this.buffer.put(4, port);
    }

    public void setExitPort(byte port) {
        this.buffer.put(5, port);
    }

    public void setNodeId(long id) {
        this.buffer.putLong(8, id);
    }

    public void setChassisId(long id) {
        this.buffer.putLong(16, id);
    }

    public void setEntryPortId(long id) {
        this.buffer.putLong(24, id);
    }

    public void setExitPortId(long id) {
        this.buffer.putLong(32, id);
    }

    @Override
    public TraceRecordBean toObject() {
        this.buffer.clear();
        short idGeneration = this.buffer.getShort();
        this.buffer.position(3);
        byte nodeType = this.buffer.get();
        byte entryPort = this.buffer.get();
        byte exitPort = this.buffer.get();
        this.buffer.position(8);
        long nodeId = this.buffer.getLong() ^ 0x55555555L;
        long chassisId = this.buffer.getLong() ^ 0x55555555L;
        long entryPortId = this.buffer.getLong() ^ 0x55555555L;
        long exitPortId = this.buffer.getLong() ^ 0x55555555L;
        TraceRecordBean bean = new TraceRecordBean(idGeneration, nodeType, entryPort, exitPort, nodeId, chassisId, entryPortId, exitPortId);
        return bean;
    }
}

