/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.command;

import com.intel.stl.fecdriver.ICommand;
import com.intel.stl.fecdriver.IStatement;
import com.intel.stl.fecdriver.messages.adapter.OobPacket;
import com.intel.stl.fecdriver.messages.adapter.RmppMad;
import com.intel.stl.fecdriver.messages.command.FVMessage;
import com.intel.stl.fecdriver.messages.command.InputArgument;
import com.intel.stl.fecdriver.messages.response.FVResponse;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class FVCommand<F>
extends FVMessage
implements ICommand<FVResponse<F>, F> {
    private InputArgument input;
    private IStatement submittingStatement;
    private OobPacket packet;
    private FVResponse<F> fvResponse;

    @Override
    public void setMessageID(long messageID) {
        super.setMessageID(messageID);
        if (this.fvResponse != null) {
            this.fvResponse.setMessageID(messageID);
        }
    }

    protected void setResponse(FVResponse<F> fvResponse) {
        fvResponse.setMessageID(this.getMessageID());
        this.fvResponse = fvResponse;
    }

    @Override
    public FVResponse<F> getResponse() {
        return this.fvResponse;
    }

    @Override
    public InputArgument getInput() {
        return this.input;
    }

    public void setInput(InputArgument input) {
        this.input = input;
        this.fvResponse.setDescription(input.toString());
    }

    @Override
    public void setConnectionInProgress(boolean inProgress) {
        if (this.fvResponse != null) {
            this.fvResponse.setConnectionInProgress(inProgress);
        }
    }

    @Override
    public void setStatement(IStatement statement) {
        this.submittingStatement = statement;
    }

    @Override
    public void setPacket(OobPacket packet) {
        this.packet = packet;
        long id = packet.getRmppMad().getCommonMad().getTransactionId();
        this.setMessageID(id);
    }

    @Override
    public OobPacket getPacket() {
        return this.packet;
    }

    @Override
    public IStatement getStatement() {
        return this.submittingStatement;
    }

    @Override
    public RmppMad prepareMad() {
        throw new UnsupportedOperationException();
    }

    public F getResult(long timeout, TimeUnit unit) throws Exception {
        F result = null;
        List<F> results = this.fvResponse.get(timeout, unit);
        if (results != null && !results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

    public List<F> getResults(long timeout, TimeUnit unit) throws Exception {
        return this.fvResponse.get(timeout, unit);
    }
}

