/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.response.sa;

import com.intel.stl.fecdriver.messages.adapter.ComposedDatagram;
import com.intel.stl.fecdriver.messages.adapter.IDatagram;
import com.intel.stl.fecdriver.messages.adapter.sa.SAData;
import com.intel.stl.fecdriver.messages.response.FVResponse;
import java.util.ArrayList;

public abstract class SAResponse<V, E extends IDatagram<V>>
extends FVResponse<V> {
    private static boolean DEBUG = false;

    @Override
    protected IDatagram<?> wrap(byte[] bytes, int offset, int totalLength) {
        SAData saData = new SAData();
        int pos = saData.wrap(bytes, offset);
        int recSize = saData.getSaHeader().getAttributeOffset() * 8;
        int numRecs = this.isSingleRecord() || recSize == 0 ? 1 : (totalLength - pos) / recSize;
        IDatagram[] records = new IDatagram[numRecs];
        ArrayList results = new ArrayList();
        for (int i = 0; i < numRecs; ++i) {
            E record = this.createRecord();
            record.wrap(bytes, pos);
            records[i] = record;
            results.add(record.toObject());
            pos += recSize;
        }
        this.setResults(results);
        ComposedDatagram data = new ComposedDatagram(records);
        saData.setData(data);
        if (DEBUG) {
            System.out.println("#Rec " + numRecs);
            saData.dump("", System.out);
        }
        return saData;
    }

    protected boolean isSingleRecord() {
        return false;
    }

    protected abstract E createRecord();
}

