/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.network.ssh.impl;

import com.intel.stl.api.Utils;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.common.SshSession;
import com.intel.stl.fecdriver.network.ssh.IJSchSession;
import com.intel.stl.fecdriver.network.ssh.JSchChannelType;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSchSession
implements IJSchSession {
    private static final Logger log = LoggerFactory.getLogger(JSchSession.class);
    private final boolean DEBUG_SESSION = false;
    private final String CONNECTION_THREAD_NAME = "JSchSession:connectionThread";
    private boolean connected;
    private Session session;
    private final SubnetDescription subnet;
    private final boolean strictHostKey;
    private final String sshKey;
    private Thread connectionThread;
    private boolean connectionThreadRunning = false;

    public JSchSession(SubnetDescription subnet, boolean strictHostKey, char[] password, String sshKey) throws JSchException {
        this.subnet = subnet;
        this.strictHostKey = strictHostKey;
        this.sshKey = sshKey;
        this.createSession(password);
    }

    public boolean isSessionConnected() {
        return this.connected;
    }

    public SshSession getSshSession() {
        if (this.session != null) {
            return new SshSession(this.session);
        }
        return null;
    }

    protected void createSession(char[] password) throws JSchException {
        HostInfo hostInfo = this.subnet.getCurrentFE();
        String host = hostInfo.getHost();
        String userName = hostInfo.getSshUserName();
        int port = hostInfo.getSshPortNum();
        JSch jsch = Utils.createJSch();
        this.session = jsch.getSession(userName, host, port);
        this.session.setPassword(new String(password));
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", this.strictHostKey ? "yes" : "no");
        config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
        this.session.setConfig(config);
        this.session.connect();
        this.connected = this.session.isConnected();
    }

    @Override
    public ChannelShell getShellChannel() throws JSchException {
        ChannelShell channel = null;
        if (!this.session.isConnected()) {
            throw new JSchException(STLMessages.STL61019_SSH_CONNECTION_FAILURE.getDescription());
        }
        channel = (ChannelShell)this.session.openChannel(JSchChannelType.SHELL_CHANNEL.getValue());
        return channel;
    }

    @Override
    public ChannelExec getExecChannel() throws JSchException {
        ChannelExec channel = null;
        if (!this.session.isConnected()) {
            throw new JSchException(STLMessages.STL61019_SSH_CONNECTION_FAILURE.getDescription());
        }
        channel = (ChannelExec)this.session.openChannel(JSchChannelType.EXEC_CHANNEL.getValue());
        return channel;
    }

    @Override
    public ChannelSftp getSFtpChannel() throws JSchException {
        ChannelSftp channel = null;
        if (!this.session.isConnected()) {
            throw new JSchException(STLMessages.STL61019_SSH_CONNECTION_FAILURE.getDescription());
        }
        channel = (ChannelSftp)this.session.openChannel(JSchChannelType.SFTP_CHANNEL.getValue());
        return channel;
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public String getSshKeyType() {
        return this.sshKey;
    }

    public synchronized void stopConnectionThread() {
        this.connectionThreadRunning = false;
    }

    public synchronized void startConnectionThread() {
        this.connectionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (JSchSession.this.connectionThreadRunning) {
                    try {
                        JSchSession.this.session.sendKeepAliveMsg();
                        System.out.println("JSchSession: connected=" + JSchSession.this.session.isConnected());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(JSchSession.this.session.getServerAliveInterval() / 2);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.connectionThread.setName("JSchSession:connectionThread");
        this.connectionThreadRunning = true;
        this.connectionThread.start();
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public void shutdown() {
        this.session.disconnect();
        this.stopConnectionThread();
    }
}

