/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.main;

import com.intel.stl.api.FMGui;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.AppDataUtils;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppComponentRegistry;
import com.intel.stl.configuration.AppConfig;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMGuiApp {
    private static Logger log;
    private static final String PARM_FIRSTRUN = "-firstrun";
    private static boolean firstrunSet;
    private static boolean firstRun;
    private Thread mainThread = null;
    private AppComponentRegistry registry;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public FMGuiApp() {
        this.mainThread = Thread.currentThread();
    }

    public boolean isFirstRun() {
        List<SubnetDescription> subnets = null;
        try {
            DatabaseManager dbMgr = this.registry.getDatabaseManager();
            if (dbMgr != null) {
                subnets = dbMgr.getSubnets();
            } else {
                this.errors.add(new RuntimeException("No Database Manager"));
            }
        }
        catch (Exception e) {
            this.errors.add(e);
        }
        return subnets == null || subnets.isEmpty();
    }

    protected void initApp() {
        AppDataUtils.initializeLogging();
        log = LoggerFactory.getLogger(FMGuiApp.class);
        char[] delim = new char[80];
        Arrays.fill(delim, '=');
        log.info(new String(delim));
        log.info("Starting application " + this.getClass().getName() + " at " + new Date() + " on " + System.getProperty("os.name"));
        this.registry = AppConfig.getAppComponentRegistry();
        try {
            this.registry.initialize();
        }
        catch (AppConfigurationException e) {
            log.error("Application configuration exception", (Throwable)e);
            this.errors.add(e);
        }
        catch (Throwable e) {
            log.error("Application configuration exception", e);
            this.errors.add(e);
        }
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public void addShutdownHook(final Callable<Void> hook) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.debug("Starts shutdown hook " + hook);
                try {
                    hook.call();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                finally {
                    try {
                        FMGuiApp.this.mainThread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void run() {
        this.addShutdownHook(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    FMGuiApp.this.registry.shutdown();
                }
                finally {
                    System.out.println("Any shutdown cleanup goes here!");
                    Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
                    for (Thread thread : threadSet) {
                        if (thread == FMGuiApp.this.mainThread || thread == Thread.currentThread()) continue;
                        thread.interrupt();
                    }
                }
                return null;
            }
        });
        this.initApp();
        FMGui ui = this.registry.getUIComponent();
        if (this.errors.isEmpty()) {
            try {
                if (!firstrunSet) {
                    firstRun = this.isFirstRun();
                }
                ui.invokeMain(firstRun);
            }
            catch (Exception e) {
                this.errors.add(e);
            }
        }
        if (!this.errors.isEmpty()) {
            if (ui != null) {
                ui.setProgress(STLMessages.STL10010_ERROR_DURING_INIT.getDescription(), 100);
                ui.showErrors(this.errors);
                ui.shutdown();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        System.exit(1);
                    }
                });
            } else {
                System.err.println(STLMessages.STL10010_ERROR_DURING_INIT.getDescription());
                for (Throwable error : this.errors) {
                    System.err.println("  " + error.getMessage());
                }
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        for (String param : args) {
            if (!PARM_FIRSTRUN.equalsIgnoreCase(param)) continue;
            firstRun = true;
            firstrunSet = true;
        }
        FMGuiApp app = new FMGuiApp();
        app.run();
    }

    static {
        firstrunSet = false;
    }
}

