/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.ValidationItem;
import com.intel.stl.ui.common.ValidationModel;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public abstract class ValidationTask<T>
extends SwingWorker<Integer, ValidationItem<T>> {
    protected final ValidationDialog dialog;
    protected ValidationModel<T> model;
    protected final List<Item<T>> items;
    protected final Item<T> toCheck;

    public ValidationTask(ValidationDialog dialog, ValidationModel<T> model, List<Item<T>> items, Item<T> toCheck) {
        this.dialog = dialog;
        this.model = model;
        this.items = items;
        this.toCheck = toCheck;
    }

    @Override
    protected void done() {
        try {
            Integer result = (Integer)this.get();
            this.onTaskSuccess(result);
        }
        catch (InterruptedException e) {
            this.onTaskFailure(e);
        }
        catch (ExecutionException e) {
            this.onTaskFailure(e.getCause());
        }
        finally {
            this.onFinally();
        }
    }

    public void onTaskSuccess(Integer result) {
        if (result == 0) {
            this.dialog.showMessage(UILabels.STL81103_NO_ISSUES_FOUND.getDescription());
            this.dialog.enableOk(true);
        } else {
            String msg = result == 1 ? UILabels.STL81104_ONE_ISSUE_FOUND.getDescription() : UILabels.STL81102_ISSUES_FOUND.getDescription(result);
            this.dialog.showMessage(msg);
            this.dialog.enableOk(false);
        }
    }

    public void onTaskFailure(Throwable caught) {
        caught.printStackTrace();
        this.dialog.showMessage(StringUtils.getErrorMessage(caught));
        this.dialog.enableOk(false);
    }

    public void onFinally() {
        this.dialog.reportProgress("100%");
        this.dialog.stopProgress();
    }

    @Override
    protected void process(List<ValidationItem<T>> intermediateResults) {
        for (ValidationItem<T> issue : intermediateResults) {
            this.model.addEntry(issue);
        }
        this.model.fireTableDataChanged();
        this.dialog.updateIssues();
    }

    protected void fixedIssue(ValidationItem<T> issue) {
        this.model.removeEntry(issue);
        this.model.fireTableDataChanged();
        this.onTaskSuccess(this.model.getRowCount());
        this.dialog.updateIssues();
    }
}

