/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.applications;

import com.intel.stl.api.management.applications.Application;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.ConfPageController;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.impl.applications.AppValidationTask;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.admin.view.applications.AppsEditorPanel;
import com.intel.stl.ui.admin.view.applications.AppsSubpageView;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class AppsPageController
extends ConfPageController<Application, AppsEditorPanel> {
    private Set<String> reserved;

    public AppsPageController(String name, String description, ImageIcon icon, AppsSubpageView view) {
        super(name, description, icon, view);
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getAdminApp();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        super.setContext(context, observer);
        this.reserved = this.mgtApi.getReservedApplications();
    }

    @Override
    protected ArrayList<Item<Application>> initData() throws Exception {
        List<Application> apps = this.mgtApi.getApplications();
        ArrayList<Item<Application>> res = new ArrayList<Item<Application>>();
        for (Application app : apps) {
            boolean isEditable = this.isEditable(app);
            Item<Application> item = new Item<Application>(res.size(), app.getName(), app, isEditable);
            item.setState(ChangeState.NONE);
            res.add(item);
        }
        return res;
    }

    protected boolean isEditable(Application app) {
        String name = app.getName();
        return !this.reserved.contains(name);
    }

    @Override
    protected Application getCopy(Application obj) {
        return obj.copy();
    }

    @Override
    protected Application createObj() {
        return new Application();
    }

    @Override
    protected void removeItemObject(String name) throws Exception {
        this.mgtApi.removeApplication(name);
    }

    @Override
    protected void saveItemObject(String oldName, Application obj) throws Exception {
        if (oldName != null) {
            this.mgtApi.updateApplication(oldName, obj);
        } else {
            this.mgtApi.addApplication(obj);
        }
    }

    @Override
    protected ValidationTask<Application> getValidationTask(ValidationDialog dialog, Item<Application> item) {
        AppValidationTask task = new AppValidationTask(dialog, this.valModel, this.orgItems, item, this.mgtApi);
        return task;
    }
}

