/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.ui.admin.impl.devicegroups.IResourceSelector;
import com.intel.stl.ui.admin.impl.devicegroups.SelectionWrapper;
import com.intel.stl.ui.admin.view.devicegroups.ListPanel;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.Context;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;

public abstract class ListSelector<E extends IAttribute>
implements IResourceSelector {
    protected final ListPanel<E> view;
    protected DefaultListModel<SelectionWrapper<E>> model;
    protected ListSelectionModel selectionModel;

    public ListSelector(ListPanel<E> view) {
        this.view = view;
        view.setSelectionModel(this.getSelectionModel());
    }

    protected ListSelectionModel getSelectionModel() {
        if (this.selectionModel == null) {
            this.selectionModel = new DefaultListSelectionModel(){
                private static final long serialVersionUID = 3726388429205355428L;

                @Override
                public void addSelectionInterval(int index0, int index1) {
                    List<Point> validIntervals = this.getValidIntervals(index0, index1);
                    for (Point interval : validIntervals) {
                        super.addSelectionInterval(interval.x, interval.y);
                    }
                }

                @Override
                public void setSelectionInterval(int index0, int index1) {
                    List<Point> validIntervals = this.getValidIntervals(index0, index1);
                    for (int i = 0; i < validIntervals.size(); ++i) {
                        Point interval = validIntervals.get(i);
                        if (i == 0) {
                            super.setSelectionInterval(interval.x, interval.y);
                            continue;
                        }
                        super.addSelectionInterval(interval.x, interval.y);
                    }
                }

                protected List<Point> getValidIntervals(int index0, int index1) {
                    ArrayList<Point> res = new ArrayList<Point>();
                    int min = index0;
                    int max = -1;
                    for (int i = index0; i <= index1; ++i) {
                        SelectionWrapper sw = ListSelector.this.model.getElementAt(i);
                        if (sw.isSelected()) {
                            if (max >= min) {
                                res.add(new Point(min, max));
                            }
                            min = i + 1;
                            continue;
                        }
                        max = i;
                    }
                    if (max >= min) {
                        res.add(new Point(min, max));
                    }
                    System.out.println(index0 + " " + index1 + " " + res);
                    return res;
                }
            };
        }
        return this.selectionModel;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
    }

    @Override
    public void clear() {
        if (this.model != null) {
            for (int i = 0; i < this.model.getSize(); ++i) {
                SelectionWrapper<E> element = this.model.getElementAt(i);
                element.setSelected(false);
                this.view.repaint();
            }
        }
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        SwingWorker<DefaultListModel<SelectionWrapper<E>>, Void> worker = this.getInitWorker(context);
        worker.execute();
    }

    private SwingWorker<DefaultListModel<SelectionWrapper<E>>, Void> getInitWorker(final Context context) {
        SwingWorker worker = new SwingWorker<DefaultListModel<SelectionWrapper<E>>, Void>(){

            @Override
            protected DefaultListModel<SelectionWrapper<E>> doInBackground() throws Exception {
                List data = ListSelector.this.getListData(context);
                DefaultListModel model = ListSelector.this.createModel(data);
                return model;
            }

            @Override
            protected void done() {
                try {
                    ListSelector.this.model = (DefaultListModel)this.get();
                    ListSelector.this.view.setModel(ListSelector.this.model);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    Util.showError(ListSelector.this.view, e);
                }
            }
        };
        return worker;
    }

    protected DefaultListModel<SelectionWrapper<E>> createModel(List<E> data) {
        DefaultListModel<SelectionWrapper<SelectionWrapper<IAttribute>>> model = new DefaultListModel<SelectionWrapper<SelectionWrapper<IAttribute>>>();
        if (data != null) {
            for (IAttribute element : data) {
                model.addElement(new SelectionWrapper<IAttribute>(element, this.getElementDesc(element)));
            }
            model.trimToSize();
        }
        return model;
    }

    protected abstract List<E> getListData(Context var1);

    protected abstract String getElementDesc(E var1);

    @Override
    public PageWeight getContextSwitchWeight() {
        return null;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return null;
    }

    @Override
    public List<IAttribute> getViewSelections() {
        List<SelectionWrapper<E>> sels = this.view.getSelectedValuesList();
        ArrayList<IAttribute> res = new ArrayList<IAttribute>(sels.size());
        for (SelectionWrapper<E> sel : sels) {
            res.add((IAttribute)sel.getObj());
        }
        return res;
    }

    @Override
    public void setModelSelections(List<? extends IAttribute> attrs) {
        if (this.model == null) {
            throw new RuntimeException("ListModel is null");
        }
        block0: for (int i = 0; i < this.model.getSize(); ++i) {
            SelectionWrapper<E> element = this.model.getElementAt(i);
            IAttribute realElement = (IAttribute)element.getObj();
            for (IAttribute iAttribute : attrs) {
                if (!iAttribute.equals(realElement)) continue;
                element.setSelected(true);
                continue block0;
            }
        }
        this.view.repaint();
    }

    @Override
    public void removeModelSelection(IAttribute attr) {
        if (this.model == null) {
            throw new RuntimeException("ListModel is null");
        }
        for (int i = 0; i < this.model.getSize(); ++i) {
            SelectionWrapper<E> element = this.model.getElementAt(i);
            IAttribute realElement = (IAttribute)element.getObj();
            if (!attr.equals(realElement)) continue;
            element.setSelected(false);
            break;
        }
        this.view.repaint();
    }

    @Override
    public void clearViewSelections() {
        this.view.clearSelection();
    }
}

