/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PortMatcher {
    private final List<Point> ranges = new ArrayList<Point>();
    private final Set<Integer> candidates = new HashSet<Integer>();

    public PortMatcher(String pattern) {
        String[] segs;
        pattern = pattern.trim();
        if (pattern.charAt(0) == '[' && pattern.charAt(pattern.length() - 1) == ']') {
            pattern = pattern.substring(1, pattern.length() - 1);
        }
        for (String seg : segs = pattern.split(",")) {
            String[] tmp = seg.split("-");
            if (tmp.length == 2) {
                int min = Integer.parseInt(tmp[0].trim());
                int max = Integer.parseInt(tmp[1].trim());
                if (max < min) {
                    throw new IllegalArgumentException("Invalid number range '" + seg + "'");
                }
                this.ranges.add(new Point(min, max));
                continue;
            }
            if (tmp.length == 1) {
                int candidate = Integer.parseInt(seg.trim());
                this.candidates.add(candidate);
                continue;
            }
            throw new IllegalArgumentException("Invalid format '" + seg + "'");
        }
    }

    public boolean match(int num) {
        if (this.candidates.contains(num)) {
            return true;
        }
        for (Point range : this.ranges) {
            if (num < range.x || num > range.y) continue;
            return true;
        }
        return false;
    }

    public List<Point> getRanges() {
        return this.ranges;
    }

    public Set<Integer> getCandidates() {
        return this.candidates;
    }

    public String toString() {
        return "PortMatcher [ranges=" + this.ranges + ", candidates=" + this.candidates + "]";
    }
}

